/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchActivateCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.BatchActivateCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.BatchCreateCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.BatchCreateCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.BatchDeactivateCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.BatchDeactivateCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.BatchUpdateCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.BatchUpdateCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.CreateCustomTargetingKeyRequest;
import com.google.ads.admanager.v1.CustomTargetingKey;
import com.google.ads.admanager.v1.CustomTargetingKeyServiceClient;
import com.google.ads.admanager.v1.GetCustomTargetingKeyRequest;
import com.google.ads.admanager.v1.ListCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.ListCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.UpdateCustomTargetingKeyRequest;
import com.google.ads.admanager.v1.stub.CustomTargetingKeyServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCustomTargetingKeyServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CustomTargetingKeyServiceStubSettings
extends StubSettings<CustomTargetingKeyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetCustomTargetingKeyRequest, CustomTargetingKey> getCustomTargetingKeySettings;
    private final PagedCallSettings<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> listCustomTargetingKeysSettings;
    private final UnaryCallSettings<CreateCustomTargetingKeyRequest, CustomTargetingKey> createCustomTargetingKeySettings;
    private final UnaryCallSettings<BatchCreateCustomTargetingKeysRequest, BatchCreateCustomTargetingKeysResponse> batchCreateCustomTargetingKeysSettings;
    private final UnaryCallSettings<UpdateCustomTargetingKeyRequest, CustomTargetingKey> updateCustomTargetingKeySettings;
    private final UnaryCallSettings<BatchUpdateCustomTargetingKeysRequest, BatchUpdateCustomTargetingKeysResponse> batchUpdateCustomTargetingKeysSettings;
    private final UnaryCallSettings<BatchActivateCustomTargetingKeysRequest, BatchActivateCustomTargetingKeysResponse> batchActivateCustomTargetingKeysSettings;
    private final UnaryCallSettings<BatchDeactivateCustomTargetingKeysRequest, BatchDeactivateCustomTargetingKeysResponse> batchDeactivateCustomTargetingKeysSettings;
    private static final PagedListDescriptor<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey> LIST_CUSTOM_TARGETING_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomTargetingKeysRequest injectToken(ListCustomTargetingKeysRequest payload, String token) {
            return ListCustomTargetingKeysRequest.newBuilder((ListCustomTargetingKeysRequest)payload).setPageToken(token).build();
        }

        public ListCustomTargetingKeysRequest injectPageSize(ListCustomTargetingKeysRequest payload, int pageSize) {
            return ListCustomTargetingKeysRequest.newBuilder((ListCustomTargetingKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomTargetingKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomTargetingKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CustomTargetingKey> extractResources(ListCustomTargetingKeysResponse payload) {
            return payload.getCustomTargetingKeysList();
        }
    };
    private static final PagedListResponseFactory<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> LIST_CUSTOM_TARGETING_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse>(){

        public ApiFuture<CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse> callable, ListCustomTargetingKeysRequest request, ApiCallContext context, ApiFuture<ListCustomTargetingKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOM_TARGETING_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse.createAsync((PageContext<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCustomTargetingKeyRequest, CustomTargetingKey> getCustomTargetingKeySettings() {
        return this.getCustomTargetingKeySettings;
    }

    public PagedCallSettings<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> listCustomTargetingKeysSettings() {
        return this.listCustomTargetingKeysSettings;
    }

    public UnaryCallSettings<CreateCustomTargetingKeyRequest, CustomTargetingKey> createCustomTargetingKeySettings() {
        return this.createCustomTargetingKeySettings;
    }

    public UnaryCallSettings<BatchCreateCustomTargetingKeysRequest, BatchCreateCustomTargetingKeysResponse> batchCreateCustomTargetingKeysSettings() {
        return this.batchCreateCustomTargetingKeysSettings;
    }

    public UnaryCallSettings<UpdateCustomTargetingKeyRequest, CustomTargetingKey> updateCustomTargetingKeySettings() {
        return this.updateCustomTargetingKeySettings;
    }

    public UnaryCallSettings<BatchUpdateCustomTargetingKeysRequest, BatchUpdateCustomTargetingKeysResponse> batchUpdateCustomTargetingKeysSettings() {
        return this.batchUpdateCustomTargetingKeysSettings;
    }

    public UnaryCallSettings<BatchActivateCustomTargetingKeysRequest, BatchActivateCustomTargetingKeysResponse> batchActivateCustomTargetingKeysSettings() {
        return this.batchActivateCustomTargetingKeysSettings;
    }

    public UnaryCallSettings<BatchDeactivateCustomTargetingKeysRequest, BatchDeactivateCustomTargetingKeysResponse> batchDeactivateCustomTargetingKeysSettings() {
        return this.batchDeactivateCustomTargetingKeysSettings;
    }

    public CustomTargetingKeyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCustomTargetingKeyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CustomTargetingKeyServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CustomTargetingKeyServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CustomTargetingKeyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCustomTargetingKeySettings = settingsBuilder.getCustomTargetingKeySettings().build();
        this.listCustomTargetingKeysSettings = settingsBuilder.listCustomTargetingKeysSettings().build();
        this.createCustomTargetingKeySettings = settingsBuilder.createCustomTargetingKeySettings().build();
        this.batchCreateCustomTargetingKeysSettings = settingsBuilder.batchCreateCustomTargetingKeysSettings().build();
        this.updateCustomTargetingKeySettings = settingsBuilder.updateCustomTargetingKeySettings().build();
        this.batchUpdateCustomTargetingKeysSettings = settingsBuilder.batchUpdateCustomTargetingKeysSettings().build();
        this.batchActivateCustomTargetingKeysSettings = settingsBuilder.batchActivateCustomTargetingKeysSettings().build();
        this.batchDeactivateCustomTargetingKeysSettings = settingsBuilder.batchDeactivateCustomTargetingKeysSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CustomTargetingKeyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCustomTargetingKeyRequest, CustomTargetingKey> getCustomTargetingKeySettings;
        private final PagedCallSettings.Builder<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> listCustomTargetingKeysSettings;
        private final UnaryCallSettings.Builder<CreateCustomTargetingKeyRequest, CustomTargetingKey> createCustomTargetingKeySettings;
        private final UnaryCallSettings.Builder<BatchCreateCustomTargetingKeysRequest, BatchCreateCustomTargetingKeysResponse> batchCreateCustomTargetingKeysSettings;
        private final UnaryCallSettings.Builder<UpdateCustomTargetingKeyRequest, CustomTargetingKey> updateCustomTargetingKeySettings;
        private final UnaryCallSettings.Builder<BatchUpdateCustomTargetingKeysRequest, BatchUpdateCustomTargetingKeysResponse> batchUpdateCustomTargetingKeysSettings;
        private final UnaryCallSettings.Builder<BatchActivateCustomTargetingKeysRequest, BatchActivateCustomTargetingKeysResponse> batchActivateCustomTargetingKeysSettings;
        private final UnaryCallSettings.Builder<BatchDeactivateCustomTargetingKeysRequest, BatchDeactivateCustomTargetingKeysResponse> batchDeactivateCustomTargetingKeysSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCustomTargetingKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCustomTargetingKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOM_TARGETING_KEYS_PAGE_STR_FACT);
            this.createCustomTargetingKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateCustomTargetingKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCustomTargetingKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateCustomTargetingKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchActivateCustomTargetingKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeactivateCustomTargetingKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomTargetingKeySettings, this.listCustomTargetingKeysSettings, this.createCustomTargetingKeySettings, this.batchCreateCustomTargetingKeysSettings, this.updateCustomTargetingKeySettings, this.batchUpdateCustomTargetingKeysSettings, this.batchActivateCustomTargetingKeysSettings, this.batchDeactivateCustomTargetingKeysSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CustomTargetingKeyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCustomTargetingKeySettings = settings.getCustomTargetingKeySettings.toBuilder();
            this.listCustomTargetingKeysSettings = settings.listCustomTargetingKeysSettings.toBuilder();
            this.createCustomTargetingKeySettings = settings.createCustomTargetingKeySettings.toBuilder();
            this.batchCreateCustomTargetingKeysSettings = settings.batchCreateCustomTargetingKeysSettings.toBuilder();
            this.updateCustomTargetingKeySettings = settings.updateCustomTargetingKeySettings.toBuilder();
            this.batchUpdateCustomTargetingKeysSettings = settings.batchUpdateCustomTargetingKeysSettings.toBuilder();
            this.batchActivateCustomTargetingKeysSettings = settings.batchActivateCustomTargetingKeysSettings.toBuilder();
            this.batchDeactivateCustomTargetingKeysSettings = settings.batchDeactivateCustomTargetingKeysSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomTargetingKeySettings, this.listCustomTargetingKeysSettings, this.createCustomTargetingKeySettings, this.batchCreateCustomTargetingKeysSettings, this.updateCustomTargetingKeySettings, this.batchUpdateCustomTargetingKeysSettings, this.batchActivateCustomTargetingKeysSettings, this.batchDeactivateCustomTargetingKeysSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CustomTargetingKeyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CustomTargetingKeyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CustomTargetingKeyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CustomTargetingKeyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCustomTargetingKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCustomTargetingKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createCustomTargetingKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateCustomTargetingKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCustomTargetingKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateCustomTargetingKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchActivateCustomTargetingKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchDeactivateCustomTargetingKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCustomTargetingKeyRequest, CustomTargetingKey> getCustomTargetingKeySettings() {
            return this.getCustomTargetingKeySettings;
        }

        public PagedCallSettings.Builder<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKeyServiceClient.ListCustomTargetingKeysPagedResponse> listCustomTargetingKeysSettings() {
            return this.listCustomTargetingKeysSettings;
        }

        public UnaryCallSettings.Builder<CreateCustomTargetingKeyRequest, CustomTargetingKey> createCustomTargetingKeySettings() {
            return this.createCustomTargetingKeySettings;
        }

        public UnaryCallSettings.Builder<BatchCreateCustomTargetingKeysRequest, BatchCreateCustomTargetingKeysResponse> batchCreateCustomTargetingKeysSettings() {
            return this.batchCreateCustomTargetingKeysSettings;
        }

        public UnaryCallSettings.Builder<UpdateCustomTargetingKeyRequest, CustomTargetingKey> updateCustomTargetingKeySettings() {
            return this.updateCustomTargetingKeySettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateCustomTargetingKeysRequest, BatchUpdateCustomTargetingKeysResponse> batchUpdateCustomTargetingKeysSettings() {
            return this.batchUpdateCustomTargetingKeysSettings;
        }

        public UnaryCallSettings.Builder<BatchActivateCustomTargetingKeysRequest, BatchActivateCustomTargetingKeysResponse> batchActivateCustomTargetingKeysSettings() {
            return this.batchActivateCustomTargetingKeysSettings;
        }

        public UnaryCallSettings.Builder<BatchDeactivateCustomTargetingKeysRequest, BatchDeactivateCustomTargetingKeysResponse> batchDeactivateCustomTargetingKeysSettings() {
            return this.batchDeactivateCustomTargetingKeysSettings;
        }

        public CustomTargetingKeyServiceStubSettings build() throws IOException {
            return new CustomTargetingKeyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

