/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BrowserLanguage;
import com.google.ads.admanager.v1.BrowserLanguageServiceClient;
import com.google.ads.admanager.v1.GetBrowserLanguageRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesResponse;
import com.google.ads.admanager.v1.stub.BrowserLanguageServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonBrowserLanguageServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BrowserLanguageServiceStubSettings
extends StubSettings<BrowserLanguageServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageSettings;
    private final PagedCallSettings<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesSettings;
    private static final PagedListDescriptor<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage> LIST_BROWSER_LANGUAGES_PAGE_STR_DESC = new PagedListDescriptor<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage>(){

        public String emptyToken() {
            return "";
        }

        public ListBrowserLanguagesRequest injectToken(ListBrowserLanguagesRequest payload, String token) {
            return ListBrowserLanguagesRequest.newBuilder((ListBrowserLanguagesRequest)payload).setPageToken(token).build();
        }

        public ListBrowserLanguagesRequest injectPageSize(ListBrowserLanguagesRequest payload, int pageSize) {
            return ListBrowserLanguagesRequest.newBuilder((ListBrowserLanguagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBrowserLanguagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBrowserLanguagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BrowserLanguage> extractResources(ListBrowserLanguagesResponse payload) {
            return payload.getBrowserLanguagesList();
        }
    };
    private static final PagedListResponseFactory<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> LIST_BROWSER_LANGUAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse>(){

        public ApiFuture<BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse> callable, ListBrowserLanguagesRequest request, ApiCallContext context, ApiFuture<ListBrowserLanguagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BROWSER_LANGUAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse.createAsync((PageContext<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguage>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageSettings() {
        return this.getBrowserLanguageSettings;
    }

    public PagedCallSettings<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesSettings() {
        return this.listBrowserLanguagesSettings;
    }

    public BrowserLanguageServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBrowserLanguageServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BrowserLanguageServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BrowserLanguageServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BrowserLanguageServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getBrowserLanguageSettings = settingsBuilder.getBrowserLanguageSettings().build();
        this.listBrowserLanguagesSettings = settingsBuilder.listBrowserLanguagesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BrowserLanguageServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageSettings;
        private final PagedCallSettings.Builder<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getBrowserLanguageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBrowserLanguagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BROWSER_LANGUAGES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBrowserLanguageSettings, this.listBrowserLanguagesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BrowserLanguageServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getBrowserLanguageSettings = settings.getBrowserLanguageSettings.toBuilder();
            this.listBrowserLanguagesSettings = settings.listBrowserLanguagesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBrowserLanguageSettings, this.listBrowserLanguagesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BrowserLanguageServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BrowserLanguageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BrowserLanguageServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BrowserLanguageServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getBrowserLanguageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBrowserLanguagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageSettings() {
            return this.getBrowserLanguageSettings;
        }

        public PagedCallSettings.Builder<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesSettings() {
            return this.listBrowserLanguagesSettings;
        }

        public BrowserLanguageServiceStubSettings build() throws IOException {
            return new BrowserLanguageServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

