/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdBreak;
import com.google.ads.admanager.v1.AdBreakServiceClient;
import com.google.ads.admanager.v1.CreateAdBreakRequest;
import com.google.ads.admanager.v1.DeleteAdBreakRequest;
import com.google.ads.admanager.v1.GetAdBreakRequest;
import com.google.ads.admanager.v1.ListAdBreaksRequest;
import com.google.ads.admanager.v1.ListAdBreaksResponse;
import com.google.ads.admanager.v1.UpdateAdBreakRequest;
import com.google.ads.admanager.v1.stub.AdBreakServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonAdBreakServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AdBreakServiceStubSettings
extends StubSettings<AdBreakServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetAdBreakRequest, AdBreak> getAdBreakSettings;
    private final PagedCallSettings<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksSettings;
    private final UnaryCallSettings<CreateAdBreakRequest, AdBreak> createAdBreakSettings;
    private final UnaryCallSettings<UpdateAdBreakRequest, AdBreak> updateAdBreakSettings;
    private final UnaryCallSettings<DeleteAdBreakRequest, Empty> deleteAdBreakSettings;
    private static final PagedListDescriptor<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak> LIST_AD_BREAKS_PAGE_STR_DESC = new PagedListDescriptor<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak>(){

        public String emptyToken() {
            return "";
        }

        public ListAdBreaksRequest injectToken(ListAdBreaksRequest payload, String token) {
            return ListAdBreaksRequest.newBuilder((ListAdBreaksRequest)payload).setPageToken(token).build();
        }

        public ListAdBreaksRequest injectPageSize(ListAdBreaksRequest payload, int pageSize) {
            return ListAdBreaksRequest.newBuilder((ListAdBreaksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdBreaksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdBreaksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdBreak> extractResources(ListAdBreaksResponse payload) {
            return payload.getAdBreaksList();
        }
    };
    private static final PagedListResponseFactory<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse> LIST_AD_BREAKS_PAGE_STR_FACT = new PagedListResponseFactory<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse>(){

        public ApiFuture<AdBreakServiceClient.ListAdBreaksPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdBreaksRequest, ListAdBreaksResponse> callable, ListAdBreaksRequest request, ApiCallContext context, ApiFuture<ListAdBreaksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AD_BREAKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdBreakServiceClient.ListAdBreaksPagedResponse.createAsync((PageContext<ListAdBreaksRequest, ListAdBreaksResponse, AdBreak>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAdBreakRequest, AdBreak> getAdBreakSettings() {
        return this.getAdBreakSettings;
    }

    public PagedCallSettings<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksSettings() {
        return this.listAdBreaksSettings;
    }

    public UnaryCallSettings<CreateAdBreakRequest, AdBreak> createAdBreakSettings() {
        return this.createAdBreakSettings;
    }

    public UnaryCallSettings<UpdateAdBreakRequest, AdBreak> updateAdBreakSettings() {
        return this.updateAdBreakSettings;
    }

    public UnaryCallSettings<DeleteAdBreakRequest, Empty> deleteAdBreakSettings() {
        return this.deleteAdBreakSettings;
    }

    public AdBreakServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAdBreakServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdBreakServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdBreakServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdBreakServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAdBreakSettings = settingsBuilder.getAdBreakSettings().build();
        this.listAdBreaksSettings = settingsBuilder.listAdBreaksSettings().build();
        this.createAdBreakSettings = settingsBuilder.createAdBreakSettings().build();
        this.updateAdBreakSettings = settingsBuilder.updateAdBreakSettings().build();
        this.deleteAdBreakSettings = settingsBuilder.deleteAdBreakSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdBreakServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAdBreakRequest, AdBreak> getAdBreakSettings;
        private final PagedCallSettings.Builder<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksSettings;
        private final UnaryCallSettings.Builder<CreateAdBreakRequest, AdBreak> createAdBreakSettings;
        private final UnaryCallSettings.Builder<UpdateAdBreakRequest, AdBreak> updateAdBreakSettings;
        private final UnaryCallSettings.Builder<DeleteAdBreakRequest, Empty> deleteAdBreakSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAdBreakSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAdBreaksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AD_BREAKS_PAGE_STR_FACT);
            this.createAdBreakSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAdBreakSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAdBreakSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdBreakSettings, this.listAdBreaksSettings, this.createAdBreakSettings, this.updateAdBreakSettings, this.deleteAdBreakSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdBreakServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getAdBreakSettings = settings.getAdBreakSettings.toBuilder();
            this.listAdBreaksSettings = settings.listAdBreaksSettings.toBuilder();
            this.createAdBreakSettings = settings.createAdBreakSettings.toBuilder();
            this.updateAdBreakSettings = settings.updateAdBreakSettings.toBuilder();
            this.deleteAdBreakSettings = settings.deleteAdBreakSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdBreakSettings, this.listAdBreaksSettings, this.createAdBreakSettings, this.updateAdBreakSettings, this.deleteAdBreakSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdBreakServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdBreakServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdBreakServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdBreakServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAdBreakSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdBreaksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAdBreakSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateAdBreakSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAdBreakSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAdBreakRequest, AdBreak> getAdBreakSettings() {
            return this.getAdBreakSettings;
        }

        public PagedCallSettings.Builder<ListAdBreaksRequest, ListAdBreaksResponse, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksSettings() {
            return this.listAdBreaksSettings;
        }

        public UnaryCallSettings.Builder<CreateAdBreakRequest, AdBreak> createAdBreakSettings() {
            return this.createAdBreakSettings;
        }

        public UnaryCallSettings.Builder<UpdateAdBreakRequest, AdBreak> updateAdBreakSettings() {
            return this.updateAdBreakSettings;
        }

        public UnaryCallSettings.Builder<DeleteAdBreakRequest, Empty> deleteAdBreakSettings() {
            return this.deleteAdBreakSettings;
        }

        public AdBreakServiceStubSettings build() throws IOException {
            return new AdBreakServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

