/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetProgrammaticBuyerRequest;
import com.google.ads.admanager.v1.ListProgrammaticBuyersRequest;
import com.google.ads.admanager.v1.ListProgrammaticBuyersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.ProgrammaticBuyer;
import com.google.ads.admanager.v1.ProgrammaticBuyerName;
import com.google.ads.admanager.v1.ProgrammaticBuyerServiceSettings;
import com.google.ads.admanager.v1.stub.ProgrammaticBuyerServiceStub;
import com.google.ads.admanager.v1.stub.ProgrammaticBuyerServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ProgrammaticBuyerServiceClient
implements BackgroundResource {
    private final ProgrammaticBuyerServiceSettings settings;
    private final ProgrammaticBuyerServiceStub stub;

    public static final ProgrammaticBuyerServiceClient create() throws IOException {
        return ProgrammaticBuyerServiceClient.create(ProgrammaticBuyerServiceSettings.newBuilder().build());
    }

    public static final ProgrammaticBuyerServiceClient create(ProgrammaticBuyerServiceSettings settings) throws IOException {
        return new ProgrammaticBuyerServiceClient(settings);
    }

    public static final ProgrammaticBuyerServiceClient create(ProgrammaticBuyerServiceStub stub) {
        return new ProgrammaticBuyerServiceClient(stub);
    }

    protected ProgrammaticBuyerServiceClient(ProgrammaticBuyerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProgrammaticBuyerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ProgrammaticBuyerServiceClient(ProgrammaticBuyerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProgrammaticBuyerServiceSettings getSettings() {
        return this.settings;
    }

    public ProgrammaticBuyerServiceStub getStub() {
        return this.stub;
    }

    public final ProgrammaticBuyer getProgrammaticBuyer(ProgrammaticBuyerName name) {
        GetProgrammaticBuyerRequest request = GetProgrammaticBuyerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProgrammaticBuyer(request);
    }

    public final ProgrammaticBuyer getProgrammaticBuyer(String name) {
        GetProgrammaticBuyerRequest request = GetProgrammaticBuyerRequest.newBuilder().setName(name).build();
        return this.getProgrammaticBuyer(request);
    }

    public final ProgrammaticBuyer getProgrammaticBuyer(GetProgrammaticBuyerRequest request) {
        return (ProgrammaticBuyer)this.getProgrammaticBuyerCallable().call((Object)request);
    }

    public final UnaryCallable<GetProgrammaticBuyerRequest, ProgrammaticBuyer> getProgrammaticBuyerCallable() {
        return this.stub.getProgrammaticBuyerCallable();
    }

    public final ListProgrammaticBuyersPagedResponse listProgrammaticBuyers(NetworkName parent) {
        ListProgrammaticBuyersRequest request = ListProgrammaticBuyersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProgrammaticBuyers(request);
    }

    public final ListProgrammaticBuyersPagedResponse listProgrammaticBuyers(String parent) {
        ListProgrammaticBuyersRequest request = ListProgrammaticBuyersRequest.newBuilder().setParent(parent).build();
        return this.listProgrammaticBuyers(request);
    }

    public final ListProgrammaticBuyersPagedResponse listProgrammaticBuyers(ListProgrammaticBuyersRequest request) {
        return (ListProgrammaticBuyersPagedResponse)((Object)this.listProgrammaticBuyersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProgrammaticBuyersRequest, ListProgrammaticBuyersPagedResponse> listProgrammaticBuyersPagedCallable() {
        return this.stub.listProgrammaticBuyersPagedCallable();
    }

    public final UnaryCallable<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse> listProgrammaticBuyersCallable() {
        return this.stub.listProgrammaticBuyersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProgrammaticBuyersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer, ListProgrammaticBuyersPage, ListProgrammaticBuyersFixedSizeCollection> {
        private ListProgrammaticBuyersFixedSizeCollection(List<ListProgrammaticBuyersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProgrammaticBuyersFixedSizeCollection createEmptyCollection() {
            return new ListProgrammaticBuyersFixedSizeCollection(null, 0);
        }

        protected ListProgrammaticBuyersFixedSizeCollection createCollection(List<ListProgrammaticBuyersPage> pages, int collectionSize) {
            return new ListProgrammaticBuyersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProgrammaticBuyersPage
    extends AbstractPage<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer, ListProgrammaticBuyersPage> {
        private ListProgrammaticBuyersPage(PageContext<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer> context, ListProgrammaticBuyersResponse response) {
            super(context, (Object)response);
        }

        private static ListProgrammaticBuyersPage createEmptyPage() {
            return new ListProgrammaticBuyersPage(null, null);
        }

        protected ListProgrammaticBuyersPage createPage(PageContext<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer> context, ListProgrammaticBuyersResponse response) {
            return new ListProgrammaticBuyersPage(context, response);
        }

        public ApiFuture<ListProgrammaticBuyersPage> createPageAsync(PageContext<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer> context, ApiFuture<ListProgrammaticBuyersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProgrammaticBuyersPagedResponse
    extends AbstractPagedListResponse<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer, ListProgrammaticBuyersPage, ListProgrammaticBuyersFixedSizeCollection> {
        public static ApiFuture<ListProgrammaticBuyersPagedResponse> createAsync(PageContext<ListProgrammaticBuyersRequest, ListProgrammaticBuyersResponse, ProgrammaticBuyer> context, ApiFuture<ListProgrammaticBuyersResponse> futureResponse) {
            ApiFuture<ListProgrammaticBuyersPage> futurePage = ListProgrammaticBuyersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProgrammaticBuyersPagedResponse((ListProgrammaticBuyersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProgrammaticBuyersPagedResponse(ListProgrammaticBuyersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProgrammaticBuyersFixedSizeCollection.createEmptyCollection());
        }
    }
}

