/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetNetworkRequest;
import com.google.ads.admanager.v1.ListNetworksRequest;
import com.google.ads.admanager.v1.ListNetworksResponse;
import com.google.ads.admanager.v1.Network;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.NetworkServiceSettings;
import com.google.ads.admanager.v1.stub.NetworkServiceStub;
import com.google.ads.admanager.v1.stub.NetworkServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkServiceClient
implements BackgroundResource {
    private final NetworkServiceSettings settings;
    private final NetworkServiceStub stub;

    public static final NetworkServiceClient create() throws IOException {
        return NetworkServiceClient.create(NetworkServiceSettings.newBuilder().build());
    }

    public static final NetworkServiceClient create(NetworkServiceSettings settings) throws IOException {
        return new NetworkServiceClient(settings);
    }

    public static final NetworkServiceClient create(NetworkServiceStub stub) {
        return new NetworkServiceClient(stub);
    }

    protected NetworkServiceClient(NetworkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected NetworkServiceClient(NetworkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkServiceSettings getSettings() {
        return this.settings;
    }

    public NetworkServiceStub getStub() {
        return this.stub;
    }

    public final Network getNetwork(NetworkName name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(String name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(GetNetworkRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    public final ListNetworksPagedResponse listNetworks(ListNetworksRequest request) {
        return (ListNetworksPagedResponse)((Object)this.listNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.stub.listNetworksPagedCallable();
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.stub.listNetworksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        private ListNetworksFixedSizeCollection(List<ListNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworksFixedSizeCollection createEmptyCollection() {
            return new ListNetworksFixedSizeCollection(null, 0);
        }

        protected ListNetworksFixedSizeCollection createCollection(List<ListNetworksPage> pages, int collectionSize) {
            return new ListNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworksPage
    extends AbstractPage<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage> {
        private ListNetworksPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworksPage createEmptyPage() {
            return new ListNetworksPage(null, null);
        }

        protected ListNetworksPage createPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            return new ListNetworksPage(context, response);
        }

        public ApiFuture<ListNetworksPage> createPageAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworksPagedResponse
    extends AbstractPagedListResponse<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        public static ApiFuture<ListNetworksPagedResponse> createAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            ApiFuture<ListNetworksPage> futurePage = ListNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworksPagedResponse((ListNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworksPagedResponse(ListNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworksFixedSizeCollection.createEmptyCollection());
        }
    }
}

