/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.ContentLabel;
import com.google.ads.admanager.v1.ContentLabelName;
import com.google.ads.admanager.v1.ContentLabelServiceSettings;
import com.google.ads.admanager.v1.GetContentLabelRequest;
import com.google.ads.admanager.v1.ListContentLabelsRequest;
import com.google.ads.admanager.v1.ListContentLabelsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.ContentLabelServiceStub;
import com.google.ads.admanager.v1.stub.ContentLabelServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContentLabelServiceClient
implements BackgroundResource {
    private final ContentLabelServiceSettings settings;
    private final ContentLabelServiceStub stub;

    public static final ContentLabelServiceClient create() throws IOException {
        return ContentLabelServiceClient.create(ContentLabelServiceSettings.newBuilder().build());
    }

    public static final ContentLabelServiceClient create(ContentLabelServiceSettings settings) throws IOException {
        return new ContentLabelServiceClient(settings);
    }

    public static final ContentLabelServiceClient create(ContentLabelServiceStub stub) {
        return new ContentLabelServiceClient(stub);
    }

    protected ContentLabelServiceClient(ContentLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContentLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ContentLabelServiceClient(ContentLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContentLabelServiceSettings getSettings() {
        return this.settings;
    }

    public ContentLabelServiceStub getStub() {
        return this.stub;
    }

    public final ContentLabel getContentLabel(ContentLabelName name) {
        GetContentLabelRequest request = GetContentLabelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContentLabel(request);
    }

    public final ContentLabel getContentLabel(String name) {
        GetContentLabelRequest request = GetContentLabelRequest.newBuilder().setName(name).build();
        return this.getContentLabel(request);
    }

    public final ContentLabel getContentLabel(GetContentLabelRequest request) {
        return (ContentLabel)this.getContentLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetContentLabelRequest, ContentLabel> getContentLabelCallable() {
        return this.stub.getContentLabelCallable();
    }

    public final ListContentLabelsPagedResponse listContentLabels(NetworkName parent) {
        ListContentLabelsRequest request = ListContentLabelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContentLabels(request);
    }

    public final ListContentLabelsPagedResponse listContentLabels(String parent) {
        ListContentLabelsRequest request = ListContentLabelsRequest.newBuilder().setParent(parent).build();
        return this.listContentLabels(request);
    }

    public final ListContentLabelsPagedResponse listContentLabels(ListContentLabelsRequest request) {
        return (ListContentLabelsPagedResponse)((Object)this.listContentLabelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContentLabelsRequest, ListContentLabelsPagedResponse> listContentLabelsPagedCallable() {
        return this.stub.listContentLabelsPagedCallable();
    }

    public final UnaryCallable<ListContentLabelsRequest, ListContentLabelsResponse> listContentLabelsCallable() {
        return this.stub.listContentLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListContentLabelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel, ListContentLabelsPage, ListContentLabelsFixedSizeCollection> {
        private ListContentLabelsFixedSizeCollection(List<ListContentLabelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContentLabelsFixedSizeCollection createEmptyCollection() {
            return new ListContentLabelsFixedSizeCollection(null, 0);
        }

        protected ListContentLabelsFixedSizeCollection createCollection(List<ListContentLabelsPage> pages, int collectionSize) {
            return new ListContentLabelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContentLabelsPage
    extends AbstractPage<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel, ListContentLabelsPage> {
        private ListContentLabelsPage(PageContext<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel> context, ListContentLabelsResponse response) {
            super(context, (Object)response);
        }

        private static ListContentLabelsPage createEmptyPage() {
            return new ListContentLabelsPage(null, null);
        }

        protected ListContentLabelsPage createPage(PageContext<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel> context, ListContentLabelsResponse response) {
            return new ListContentLabelsPage(context, response);
        }

        public ApiFuture<ListContentLabelsPage> createPageAsync(PageContext<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel> context, ApiFuture<ListContentLabelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContentLabelsPagedResponse
    extends AbstractPagedListResponse<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel, ListContentLabelsPage, ListContentLabelsFixedSizeCollection> {
        public static ApiFuture<ListContentLabelsPagedResponse> createAsync(PageContext<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel> context, ApiFuture<ListContentLabelsResponse> futureResponse) {
            ApiFuture<ListContentLabelsPage> futurePage = ListContentLabelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContentLabelsPagedResponse((ListContentLabelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContentLabelsPagedResponse(ListContentLabelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContentLabelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

