/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.Application;
import com.google.ads.admanager.v1.ApplicationName;
import com.google.ads.admanager.v1.ApplicationServiceSettings;
import com.google.ads.admanager.v1.GetApplicationRequest;
import com.google.ads.admanager.v1.ListApplicationsRequest;
import com.google.ads.admanager.v1.ListApplicationsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.ApplicationServiceStub;
import com.google.ads.admanager.v1.stub.ApplicationServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ApplicationServiceClient
implements BackgroundResource {
    private final ApplicationServiceSettings settings;
    private final ApplicationServiceStub stub;

    public static final ApplicationServiceClient create() throws IOException {
        return ApplicationServiceClient.create(ApplicationServiceSettings.newBuilder().build());
    }

    public static final ApplicationServiceClient create(ApplicationServiceSettings settings) throws IOException {
        return new ApplicationServiceClient(settings);
    }

    public static final ApplicationServiceClient create(ApplicationServiceStub stub) {
        return new ApplicationServiceClient(stub);
    }

    protected ApplicationServiceClient(ApplicationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ApplicationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ApplicationServiceClient(ApplicationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ApplicationServiceSettings getSettings() {
        return this.settings;
    }

    public ApplicationServiceStub getStub() {
        return this.stub;
    }

    public final Application getApplication(ApplicationName name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApplication(request);
    }

    public final Application getApplication(String name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name).build();
        return this.getApplication(request);
    }

    public final Application getApplication(GetApplicationRequest request) {
        return (Application)this.getApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.stub.getApplicationCallable();
    }

    public final ListApplicationsPagedResponse listApplications(NetworkName parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(String parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(ListApplicationsRequest request) {
        return (ListApplicationsPagedResponse)((Object)this.listApplicationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.stub.listApplicationsPagedCallable();
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.stub.listApplicationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListApplicationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        private ListApplicationsFixedSizeCollection(List<ListApplicationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApplicationsFixedSizeCollection createEmptyCollection() {
            return new ListApplicationsFixedSizeCollection(null, 0);
        }

        protected ListApplicationsFixedSizeCollection createCollection(List<ListApplicationsPage> pages, int collectionSize) {
            return new ListApplicationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApplicationsPage
    extends AbstractPage<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage> {
        private ListApplicationsPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            super(context, (Object)response);
        }

        private static ListApplicationsPage createEmptyPage() {
            return new ListApplicationsPage(null, null);
        }

        protected ListApplicationsPage createPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            return new ListApplicationsPage(context, response);
        }

        public ApiFuture<ListApplicationsPage> createPageAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApplicationsPagedResponse
    extends AbstractPagedListResponse<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        public static ApiFuture<ListApplicationsPagedResponse> createAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            ApiFuture<ListApplicationsPage> futurePage = ListApplicationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApplicationsPagedResponse((ListApplicationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApplicationsPagedResponse(ListApplicationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApplicationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

