/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.DeviceManufacturer;
import com.google.ads.admanager.v1.DeviceManufacturerServiceClient;
import com.google.ads.admanager.v1.GetDeviceManufacturerRequest;
import com.google.ads.admanager.v1.ListDeviceManufacturersRequest;
import com.google.ads.admanager.v1.ListDeviceManufacturersResponse;
import com.google.ads.admanager.v1.stub.DeviceManufacturerServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonDeviceManufacturerServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeviceManufacturerServiceStubSettings
extends StubSettings<DeviceManufacturerServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetDeviceManufacturerRequest, DeviceManufacturer> getDeviceManufacturerSettings;
    private final PagedCallSettings<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> listDeviceManufacturersSettings;
    private static final PagedListDescriptor<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer> LIST_DEVICE_MANUFACTURERS_PAGE_STR_DESC = new PagedListDescriptor<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer>(){

        public String emptyToken() {
            return "";
        }

        public ListDeviceManufacturersRequest injectToken(ListDeviceManufacturersRequest payload, String token) {
            return ListDeviceManufacturersRequest.newBuilder((ListDeviceManufacturersRequest)payload).setPageToken(token).build();
        }

        public ListDeviceManufacturersRequest injectPageSize(ListDeviceManufacturersRequest payload, int pageSize) {
            return ListDeviceManufacturersRequest.newBuilder((ListDeviceManufacturersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeviceManufacturersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeviceManufacturersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeviceManufacturer> extractResources(ListDeviceManufacturersResponse payload) {
            return payload.getDeviceManufacturersList();
        }
    };
    private static final PagedListResponseFactory<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> LIST_DEVICE_MANUFACTURERS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse>(){

        public ApiFuture<DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse> callable, ListDeviceManufacturersRequest request, ApiCallContext context, ApiFuture<ListDeviceManufacturersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICE_MANUFACTURERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse.createAsync((PageContext<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDeviceManufacturerRequest, DeviceManufacturer> getDeviceManufacturerSettings() {
        return this.getDeviceManufacturerSettings;
    }

    public PagedCallSettings<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> listDeviceManufacturersSettings() {
        return this.listDeviceManufacturersSettings;
    }

    public DeviceManufacturerServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeviceManufacturerServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeviceManufacturerServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeviceManufacturerServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeviceManufacturerServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getDeviceManufacturerSettings = settingsBuilder.getDeviceManufacturerSettings().build();
        this.listDeviceManufacturersSettings = settingsBuilder.listDeviceManufacturersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeviceManufacturerServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDeviceManufacturerRequest, DeviceManufacturer> getDeviceManufacturerSettings;
        private final PagedCallSettings.Builder<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> listDeviceManufacturersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDeviceManufacturerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceManufacturersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICE_MANUFACTURERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceManufacturerSettings, this.listDeviceManufacturersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DeviceManufacturerServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getDeviceManufacturerSettings = settings.getDeviceManufacturerSettings.toBuilder();
            this.listDeviceManufacturersSettings = settings.listDeviceManufacturersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceManufacturerSettings, this.listDeviceManufacturersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeviceManufacturerServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeviceManufacturerServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeviceManufacturerServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeviceManufacturerServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDeviceManufacturerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDeviceManufacturersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDeviceManufacturerRequest, DeviceManufacturer> getDeviceManufacturerSettings() {
            return this.getDeviceManufacturerSettings;
        }

        public PagedCallSettings.Builder<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturerServiceClient.ListDeviceManufacturersPagedResponse> listDeviceManufacturersSettings() {
            return this.listDeviceManufacturersSettings;
        }

        public DeviceManufacturerServiceStubSettings build() throws IOException {
            return new DeviceManufacturerServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

