/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdUnit;
import com.google.ads.admanager.v1.AdUnitServiceClient;
import com.google.ads.admanager.v1.AdUnitSize;
import com.google.ads.admanager.v1.BatchActivateAdUnitsRequest;
import com.google.ads.admanager.v1.BatchActivateAdUnitsResponse;
import com.google.ads.admanager.v1.BatchArchiveAdUnitsRequest;
import com.google.ads.admanager.v1.BatchArchiveAdUnitsResponse;
import com.google.ads.admanager.v1.BatchCreateAdUnitsRequest;
import com.google.ads.admanager.v1.BatchCreateAdUnitsResponse;
import com.google.ads.admanager.v1.BatchDeactivateAdUnitsRequest;
import com.google.ads.admanager.v1.BatchDeactivateAdUnitsResponse;
import com.google.ads.admanager.v1.BatchUpdateAdUnitsRequest;
import com.google.ads.admanager.v1.BatchUpdateAdUnitsResponse;
import com.google.ads.admanager.v1.CreateAdUnitRequest;
import com.google.ads.admanager.v1.GetAdUnitRequest;
import com.google.ads.admanager.v1.ListAdUnitSizesRequest;
import com.google.ads.admanager.v1.ListAdUnitSizesResponse;
import com.google.ads.admanager.v1.ListAdUnitsRequest;
import com.google.ads.admanager.v1.ListAdUnitsResponse;
import com.google.ads.admanager.v1.UpdateAdUnitRequest;
import com.google.ads.admanager.v1.stub.AdUnitServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonAdUnitServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AdUnitServiceStubSettings
extends StubSettings<AdUnitServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetAdUnitRequest, AdUnit> getAdUnitSettings;
    private final PagedCallSettings<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse> listAdUnitsSettings;
    private final PagedCallSettings<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse> listAdUnitSizesSettings;
    private final UnaryCallSettings<CreateAdUnitRequest, AdUnit> createAdUnitSettings;
    private final UnaryCallSettings<UpdateAdUnitRequest, AdUnit> updateAdUnitSettings;
    private final UnaryCallSettings<BatchCreateAdUnitsRequest, BatchCreateAdUnitsResponse> batchCreateAdUnitsSettings;
    private final UnaryCallSettings<BatchUpdateAdUnitsRequest, BatchUpdateAdUnitsResponse> batchUpdateAdUnitsSettings;
    private final UnaryCallSettings<BatchActivateAdUnitsRequest, BatchActivateAdUnitsResponse> batchActivateAdUnitsSettings;
    private final UnaryCallSettings<BatchDeactivateAdUnitsRequest, BatchDeactivateAdUnitsResponse> batchDeactivateAdUnitsSettings;
    private final UnaryCallSettings<BatchArchiveAdUnitsRequest, BatchArchiveAdUnitsResponse> batchArchiveAdUnitsSettings;
    private static final PagedListDescriptor<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit> LIST_AD_UNITS_PAGE_STR_DESC = new PagedListDescriptor<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit>(){

        public String emptyToken() {
            return "";
        }

        public ListAdUnitsRequest injectToken(ListAdUnitsRequest payload, String token) {
            return ListAdUnitsRequest.newBuilder((ListAdUnitsRequest)payload).setPageToken(token).build();
        }

        public ListAdUnitsRequest injectPageSize(ListAdUnitsRequest payload, int pageSize) {
            return ListAdUnitsRequest.newBuilder((ListAdUnitsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdUnitsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdUnitsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdUnit> extractResources(ListAdUnitsResponse payload) {
            return payload.getAdUnitsList();
        }
    };
    private static final PagedListDescriptor<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitSize> LIST_AD_UNIT_SIZES_PAGE_STR_DESC = new PagedListDescriptor<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitSize>(){

        public String emptyToken() {
            return "";
        }

        public ListAdUnitSizesRequest injectToken(ListAdUnitSizesRequest payload, String token) {
            return ListAdUnitSizesRequest.newBuilder((ListAdUnitSizesRequest)payload).setPageToken(token).build();
        }

        public ListAdUnitSizesRequest injectPageSize(ListAdUnitSizesRequest payload, int pageSize) {
            return ListAdUnitSizesRequest.newBuilder((ListAdUnitSizesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAdUnitSizesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAdUnitSizesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdUnitSize> extractResources(ListAdUnitSizesResponse payload) {
            return payload.getAdUnitSizesList();
        }
    };
    private static final PagedListResponseFactory<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse> LIST_AD_UNITS_PAGE_STR_FACT = new PagedListResponseFactory<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse>(){

        public ApiFuture<AdUnitServiceClient.ListAdUnitsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdUnitsRequest, ListAdUnitsResponse> callable, ListAdUnitsRequest request, ApiCallContext context, ApiFuture<ListAdUnitsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AD_UNITS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdUnitServiceClient.ListAdUnitsPagedResponse.createAsync((PageContext<ListAdUnitsRequest, ListAdUnitsResponse, AdUnit>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse> LIST_AD_UNIT_SIZES_PAGE_STR_FACT = new PagedListResponseFactory<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse>(){

        public ApiFuture<AdUnitServiceClient.ListAdUnitSizesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAdUnitSizesRequest, ListAdUnitSizesResponse> callable, ListAdUnitSizesRequest request, ApiCallContext context, ApiFuture<ListAdUnitSizesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AD_UNIT_SIZES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdUnitServiceClient.ListAdUnitSizesPagedResponse.createAsync((PageContext<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitSize>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAdUnitRequest, AdUnit> getAdUnitSettings() {
        return this.getAdUnitSettings;
    }

    public PagedCallSettings<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse> listAdUnitsSettings() {
        return this.listAdUnitsSettings;
    }

    public PagedCallSettings<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse> listAdUnitSizesSettings() {
        return this.listAdUnitSizesSettings;
    }

    public UnaryCallSettings<CreateAdUnitRequest, AdUnit> createAdUnitSettings() {
        return this.createAdUnitSettings;
    }

    public UnaryCallSettings<UpdateAdUnitRequest, AdUnit> updateAdUnitSettings() {
        return this.updateAdUnitSettings;
    }

    public UnaryCallSettings<BatchCreateAdUnitsRequest, BatchCreateAdUnitsResponse> batchCreateAdUnitsSettings() {
        return this.batchCreateAdUnitsSettings;
    }

    public UnaryCallSettings<BatchUpdateAdUnitsRequest, BatchUpdateAdUnitsResponse> batchUpdateAdUnitsSettings() {
        return this.batchUpdateAdUnitsSettings;
    }

    public UnaryCallSettings<BatchActivateAdUnitsRequest, BatchActivateAdUnitsResponse> batchActivateAdUnitsSettings() {
        return this.batchActivateAdUnitsSettings;
    }

    public UnaryCallSettings<BatchDeactivateAdUnitsRequest, BatchDeactivateAdUnitsResponse> batchDeactivateAdUnitsSettings() {
        return this.batchDeactivateAdUnitsSettings;
    }

    public UnaryCallSettings<BatchArchiveAdUnitsRequest, BatchArchiveAdUnitsResponse> batchArchiveAdUnitsSettings() {
        return this.batchArchiveAdUnitsSettings;
    }

    public AdUnitServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAdUnitServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdUnitServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdUnitServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdUnitServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAdUnitSettings = settingsBuilder.getAdUnitSettings().build();
        this.listAdUnitsSettings = settingsBuilder.listAdUnitsSettings().build();
        this.listAdUnitSizesSettings = settingsBuilder.listAdUnitSizesSettings().build();
        this.createAdUnitSettings = settingsBuilder.createAdUnitSettings().build();
        this.updateAdUnitSettings = settingsBuilder.updateAdUnitSettings().build();
        this.batchCreateAdUnitsSettings = settingsBuilder.batchCreateAdUnitsSettings().build();
        this.batchUpdateAdUnitsSettings = settingsBuilder.batchUpdateAdUnitsSettings().build();
        this.batchActivateAdUnitsSettings = settingsBuilder.batchActivateAdUnitsSettings().build();
        this.batchDeactivateAdUnitsSettings = settingsBuilder.batchDeactivateAdUnitsSettings().build();
        this.batchArchiveAdUnitsSettings = settingsBuilder.batchArchiveAdUnitsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdUnitServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAdUnitRequest, AdUnit> getAdUnitSettings;
        private final PagedCallSettings.Builder<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse> listAdUnitsSettings;
        private final PagedCallSettings.Builder<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse> listAdUnitSizesSettings;
        private final UnaryCallSettings.Builder<CreateAdUnitRequest, AdUnit> createAdUnitSettings;
        private final UnaryCallSettings.Builder<UpdateAdUnitRequest, AdUnit> updateAdUnitSettings;
        private final UnaryCallSettings.Builder<BatchCreateAdUnitsRequest, BatchCreateAdUnitsResponse> batchCreateAdUnitsSettings;
        private final UnaryCallSettings.Builder<BatchUpdateAdUnitsRequest, BatchUpdateAdUnitsResponse> batchUpdateAdUnitsSettings;
        private final UnaryCallSettings.Builder<BatchActivateAdUnitsRequest, BatchActivateAdUnitsResponse> batchActivateAdUnitsSettings;
        private final UnaryCallSettings.Builder<BatchDeactivateAdUnitsRequest, BatchDeactivateAdUnitsResponse> batchDeactivateAdUnitsSettings;
        private final UnaryCallSettings.Builder<BatchArchiveAdUnitsRequest, BatchArchiveAdUnitsResponse> batchArchiveAdUnitsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAdUnitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAdUnitsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AD_UNITS_PAGE_STR_FACT);
            this.listAdUnitSizesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AD_UNIT_SIZES_PAGE_STR_FACT);
            this.createAdUnitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAdUnitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateAdUnitsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateAdUnitsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchActivateAdUnitsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeactivateAdUnitsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchArchiveAdUnitsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdUnitSettings, this.listAdUnitsSettings, this.listAdUnitSizesSettings, this.createAdUnitSettings, this.updateAdUnitSettings, this.batchCreateAdUnitsSettings, this.batchUpdateAdUnitsSettings, this.batchActivateAdUnitsSettings, this.batchDeactivateAdUnitsSettings, this.batchArchiveAdUnitsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdUnitServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getAdUnitSettings = settings.getAdUnitSettings.toBuilder();
            this.listAdUnitsSettings = settings.listAdUnitsSettings.toBuilder();
            this.listAdUnitSizesSettings = settings.listAdUnitSizesSettings.toBuilder();
            this.createAdUnitSettings = settings.createAdUnitSettings.toBuilder();
            this.updateAdUnitSettings = settings.updateAdUnitSettings.toBuilder();
            this.batchCreateAdUnitsSettings = settings.batchCreateAdUnitsSettings.toBuilder();
            this.batchUpdateAdUnitsSettings = settings.batchUpdateAdUnitsSettings.toBuilder();
            this.batchActivateAdUnitsSettings = settings.batchActivateAdUnitsSettings.toBuilder();
            this.batchDeactivateAdUnitsSettings = settings.batchDeactivateAdUnitsSettings.toBuilder();
            this.batchArchiveAdUnitsSettings = settings.batchArchiveAdUnitsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAdUnitSettings, this.listAdUnitsSettings, this.listAdUnitSizesSettings, this.createAdUnitSettings, this.updateAdUnitSettings, this.batchCreateAdUnitsSettings, this.batchUpdateAdUnitsSettings, this.batchActivateAdUnitsSettings, this.batchDeactivateAdUnitsSettings, this.batchArchiveAdUnitsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdUnitServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdUnitServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdUnitServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdUnitServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAdUnitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAdUnitSizesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAdUnitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateAdUnitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchActivateAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchDeactivateAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchArchiveAdUnitsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAdUnitRequest, AdUnit> getAdUnitSettings() {
            return this.getAdUnitSettings;
        }

        public PagedCallSettings.Builder<ListAdUnitsRequest, ListAdUnitsResponse, AdUnitServiceClient.ListAdUnitsPagedResponse> listAdUnitsSettings() {
            return this.listAdUnitsSettings;
        }

        public PagedCallSettings.Builder<ListAdUnitSizesRequest, ListAdUnitSizesResponse, AdUnitServiceClient.ListAdUnitSizesPagedResponse> listAdUnitSizesSettings() {
            return this.listAdUnitSizesSettings;
        }

        public UnaryCallSettings.Builder<CreateAdUnitRequest, AdUnit> createAdUnitSettings() {
            return this.createAdUnitSettings;
        }

        public UnaryCallSettings.Builder<UpdateAdUnitRequest, AdUnit> updateAdUnitSettings() {
            return this.updateAdUnitSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateAdUnitsRequest, BatchCreateAdUnitsResponse> batchCreateAdUnitsSettings() {
            return this.batchCreateAdUnitsSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateAdUnitsRequest, BatchUpdateAdUnitsResponse> batchUpdateAdUnitsSettings() {
            return this.batchUpdateAdUnitsSettings;
        }

        public UnaryCallSettings.Builder<BatchActivateAdUnitsRequest, BatchActivateAdUnitsResponse> batchActivateAdUnitsSettings() {
            return this.batchActivateAdUnitsSettings;
        }

        public UnaryCallSettings.Builder<BatchDeactivateAdUnitsRequest, BatchDeactivateAdUnitsResponse> batchDeactivateAdUnitsSettings() {
            return this.batchDeactivateAdUnitsSettings;
        }

        public UnaryCallSettings.Builder<BatchArchiveAdUnitsRequest, BatchArchiveAdUnitsResponse> batchArchiveAdUnitsSettings() {
            return this.batchArchiveAdUnitsSettings;
        }

        public AdUnitServiceStubSettings build() throws IOException {
            return new AdUnitServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

