/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreatePrivateAuctionRequest;
import com.google.ads.admanager.v1.GetPrivateAuctionRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsResponse;
import com.google.ads.admanager.v1.PrivateAuction;
import com.google.ads.admanager.v1.PrivateAuctionServiceClient;
import com.google.ads.admanager.v1.UpdatePrivateAuctionRequest;
import com.google.ads.admanager.v1.stub.HttpJsonPrivateAuctionServiceStub;
import com.google.ads.admanager.v1.stub.PrivateAuctionServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PrivateAuctionServiceStubSettings
extends StubSettings<PrivateAuctionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionSettings;
    private final PagedCallSettings<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsSettings;
    private final UnaryCallSettings<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionSettings;
    private final UnaryCallSettings<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionSettings;
    private static final PagedListDescriptor<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction> LIST_PRIVATE_AUCTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction>(){

        public String emptyToken() {
            return "";
        }

        public ListPrivateAuctionsRequest injectToken(ListPrivateAuctionsRequest payload, String token) {
            return ListPrivateAuctionsRequest.newBuilder((ListPrivateAuctionsRequest)payload).setPageToken(token).build();
        }

        public ListPrivateAuctionsRequest injectPageSize(ListPrivateAuctionsRequest payload, int pageSize) {
            return ListPrivateAuctionsRequest.newBuilder((ListPrivateAuctionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPrivateAuctionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPrivateAuctionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PrivateAuction> extractResources(ListPrivateAuctionsResponse payload) {
            return payload.getPrivateAuctionsList();
        }
    };
    private static final PagedListResponseFactory<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> LIST_PRIVATE_AUCTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse>(){

        public ApiFuture<PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse> callable, ListPrivateAuctionsRequest request, ApiCallContext context, ApiFuture<ListPrivateAuctionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRIVATE_AUCTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse.createAsync((PageContext<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionSettings() {
        return this.getPrivateAuctionSettings;
    }

    public PagedCallSettings<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsSettings() {
        return this.listPrivateAuctionsSettings;
    }

    public UnaryCallSettings<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionSettings() {
        return this.createPrivateAuctionSettings;
    }

    public UnaryCallSettings<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionSettings() {
        return this.updatePrivateAuctionSettings;
    }

    public PrivateAuctionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPrivateAuctionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PrivateAuctionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivateAuctionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PrivateAuctionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getPrivateAuctionSettings = settingsBuilder.getPrivateAuctionSettings().build();
        this.listPrivateAuctionsSettings = settingsBuilder.listPrivateAuctionsSettings().build();
        this.createPrivateAuctionSettings = settingsBuilder.createPrivateAuctionSettings().build();
        this.updatePrivateAuctionSettings = settingsBuilder.updatePrivateAuctionSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PrivateAuctionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionSettings;
        private final PagedCallSettings.Builder<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsSettings;
        private final UnaryCallSettings.Builder<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionSettings;
        private final UnaryCallSettings.Builder<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getPrivateAuctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPrivateAuctionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRIVATE_AUCTIONS_PAGE_STR_FACT);
            this.createPrivateAuctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePrivateAuctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPrivateAuctionSettings, this.listPrivateAuctionsSettings, this.createPrivateAuctionSettings, this.updatePrivateAuctionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PrivateAuctionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getPrivateAuctionSettings = settings.getPrivateAuctionSettings.toBuilder();
            this.listPrivateAuctionsSettings = settings.listPrivateAuctionsSettings.toBuilder();
            this.createPrivateAuctionSettings = settings.createPrivateAuctionSettings.toBuilder();
            this.updatePrivateAuctionSettings = settings.updatePrivateAuctionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPrivateAuctionSettings, this.listPrivateAuctionsSettings, this.createPrivateAuctionSettings, this.updatePrivateAuctionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PrivateAuctionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PrivateAuctionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivateAuctionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PrivateAuctionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getPrivateAuctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPrivateAuctionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createPrivateAuctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updatePrivateAuctionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionSettings() {
            return this.getPrivateAuctionSettings;
        }

        public PagedCallSettings.Builder<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuctionServiceClient.ListPrivateAuctionsPagedResponse> listPrivateAuctionsSettings() {
            return this.listPrivateAuctionsSettings;
        }

        public UnaryCallSettings.Builder<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionSettings() {
            return this.createPrivateAuctionSettings;
        }

        public UnaryCallSettings.Builder<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionSettings() {
            return this.updatePrivateAuctionSettings;
        }

        public PrivateAuctionServiceStubSettings build() throws IOException {
            return new PrivateAuctionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

