/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GeoTarget;
import com.google.ads.admanager.v1.GeoTargetServiceClient;
import com.google.ads.admanager.v1.GetGeoTargetRequest;
import com.google.ads.admanager.v1.ListGeoTargetsRequest;
import com.google.ads.admanager.v1.ListGeoTargetsResponse;
import com.google.ads.admanager.v1.stub.GeoTargetServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonGeoTargetServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class GeoTargetServiceStubSettings
extends StubSettings<GeoTargetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetGeoTargetRequest, GeoTarget> getGeoTargetSettings;
    private final PagedCallSettings<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse> listGeoTargetsSettings;
    private static final PagedListDescriptor<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget> LIST_GEO_TARGETS_PAGE_STR_DESC = new PagedListDescriptor<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget>(){

        public String emptyToken() {
            return "";
        }

        public ListGeoTargetsRequest injectToken(ListGeoTargetsRequest payload, String token) {
            return ListGeoTargetsRequest.newBuilder((ListGeoTargetsRequest)payload).setPageToken(token).build();
        }

        public ListGeoTargetsRequest injectPageSize(ListGeoTargetsRequest payload, int pageSize) {
            return ListGeoTargetsRequest.newBuilder((ListGeoTargetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGeoTargetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGeoTargetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GeoTarget> extractResources(ListGeoTargetsResponse payload) {
            return payload.getGeoTargetsList();
        }
    };
    private static final PagedListResponseFactory<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse> LIST_GEO_TARGETS_PAGE_STR_FACT = new PagedListResponseFactory<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse>(){

        public ApiFuture<GeoTargetServiceClient.ListGeoTargetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGeoTargetsRequest, ListGeoTargetsResponse> callable, ListGeoTargetsRequest request, ApiCallContext context, ApiFuture<ListGeoTargetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GEO_TARGETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GeoTargetServiceClient.ListGeoTargetsPagedResponse.createAsync((PageContext<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetGeoTargetRequest, GeoTarget> getGeoTargetSettings() {
        return this.getGeoTargetSettings;
    }

    public PagedCallSettings<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse> listGeoTargetsSettings() {
        return this.listGeoTargetsSettings;
    }

    public GeoTargetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGeoTargetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GeoTargetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GeoTargetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GeoTargetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getGeoTargetSettings = settingsBuilder.getGeoTargetSettings().build();
        this.listGeoTargetsSettings = settingsBuilder.listGeoTargetsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GeoTargetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetGeoTargetRequest, GeoTarget> getGeoTargetSettings;
        private final PagedCallSettings.Builder<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse> listGeoTargetsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getGeoTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGeoTargetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GEO_TARGETS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGeoTargetSettings, this.listGeoTargetsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GeoTargetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getGeoTargetSettings = settings.getGeoTargetSettings.toBuilder();
            this.listGeoTargetsSettings = settings.listGeoTargetsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getGeoTargetSettings, this.listGeoTargetsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GeoTargetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GeoTargetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GeoTargetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GeoTargetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getGeoTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGeoTargetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetGeoTargetRequest, GeoTarget> getGeoTargetSettings() {
            return this.getGeoTargetSettings;
        }

        public PagedCallSettings.Builder<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTargetServiceClient.ListGeoTargetsPagedResponse> listGeoTargetsSettings() {
            return this.listGeoTargetsSettings;
        }

        public GeoTargetServiceStubSettings build() throws IOException {
            return new GeoTargetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

