/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Browser;
import com.google.ads.admanager.v1.BrowserServiceClient;
import com.google.ads.admanager.v1.GetBrowserRequest;
import com.google.ads.admanager.v1.ListBrowsersRequest;
import com.google.ads.admanager.v1.ListBrowsersResponse;
import com.google.ads.admanager.v1.stub.BrowserServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonBrowserServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BrowserServiceStubSettings
extends StubSettings<BrowserServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetBrowserRequest, Browser> getBrowserSettings;
    private final PagedCallSettings<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersSettings;
    private static final PagedListDescriptor<ListBrowsersRequest, ListBrowsersResponse, Browser> LIST_BROWSERS_PAGE_STR_DESC = new PagedListDescriptor<ListBrowsersRequest, ListBrowsersResponse, Browser>(){

        public String emptyToken() {
            return "";
        }

        public ListBrowsersRequest injectToken(ListBrowsersRequest payload, String token) {
            return ListBrowsersRequest.newBuilder((ListBrowsersRequest)payload).setPageToken(token).build();
        }

        public ListBrowsersRequest injectPageSize(ListBrowsersRequest payload, int pageSize) {
            return ListBrowsersRequest.newBuilder((ListBrowsersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBrowsersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBrowsersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Browser> extractResources(ListBrowsersResponse payload) {
            return payload.getBrowsersList();
        }
    };
    private static final PagedListResponseFactory<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse> LIST_BROWSERS_PAGE_STR_FACT = new PagedListResponseFactory<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse>(){

        public ApiFuture<BrowserServiceClient.ListBrowsersPagedResponse> getFuturePagedResponse(UnaryCallable<ListBrowsersRequest, ListBrowsersResponse> callable, ListBrowsersRequest request, ApiCallContext context, ApiFuture<ListBrowsersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BROWSERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BrowserServiceClient.ListBrowsersPagedResponse.createAsync((PageContext<ListBrowsersRequest, ListBrowsersResponse, Browser>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetBrowserRequest, Browser> getBrowserSettings() {
        return this.getBrowserSettings;
    }

    public PagedCallSettings<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersSettings() {
        return this.listBrowsersSettings;
    }

    public BrowserServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBrowserServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BrowserServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BrowserServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BrowserServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getBrowserSettings = settingsBuilder.getBrowserSettings().build();
        this.listBrowsersSettings = settingsBuilder.listBrowsersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BrowserServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetBrowserRequest, Browser> getBrowserSettings;
        private final PagedCallSettings.Builder<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getBrowserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBrowsersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BROWSERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBrowserSettings, this.listBrowsersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BrowserServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getBrowserSettings = settings.getBrowserSettings.toBuilder();
            this.listBrowsersSettings = settings.listBrowsersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBrowserSettings, this.listBrowsersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BrowserServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BrowserServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BrowserServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BrowserServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getBrowserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBrowsersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetBrowserRequest, Browser> getBrowserSettings() {
            return this.getBrowserSettings;
        }

        public PagedCallSettings.Builder<ListBrowsersRequest, ListBrowsersResponse, BrowserServiceClient.ListBrowsersPagedResponse> listBrowsersSettings() {
            return this.listBrowsersSettings;
        }

        public BrowserServiceStubSettings build() throws IOException {
            return new BrowserServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

