/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CreatePrivateAuctionDealRequest;
import com.google.ads.admanager.v1.GetPrivateAuctionDealRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionDealsRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionDealsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.PrivateAuctionDeal;
import com.google.ads.admanager.v1.PrivateAuctionDealName;
import com.google.ads.admanager.v1.PrivateAuctionDealServiceSettings;
import com.google.ads.admanager.v1.UpdatePrivateAuctionDealRequest;
import com.google.ads.admanager.v1.stub.PrivateAuctionDealServiceStub;
import com.google.ads.admanager.v1.stub.PrivateAuctionDealServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PrivateAuctionDealServiceClient
implements BackgroundResource {
    private final PrivateAuctionDealServiceSettings settings;
    private final PrivateAuctionDealServiceStub stub;

    public static final PrivateAuctionDealServiceClient create() throws IOException {
        return PrivateAuctionDealServiceClient.create(PrivateAuctionDealServiceSettings.newBuilder().build());
    }

    public static final PrivateAuctionDealServiceClient create(PrivateAuctionDealServiceSettings settings) throws IOException {
        return new PrivateAuctionDealServiceClient(settings);
    }

    public static final PrivateAuctionDealServiceClient create(PrivateAuctionDealServiceStub stub) {
        return new PrivateAuctionDealServiceClient(stub);
    }

    protected PrivateAuctionDealServiceClient(PrivateAuctionDealServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PrivateAuctionDealServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PrivateAuctionDealServiceClient(PrivateAuctionDealServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PrivateAuctionDealServiceSettings getSettings() {
        return this.settings;
    }

    public PrivateAuctionDealServiceStub getStub() {
        return this.stub;
    }

    public final PrivateAuctionDeal getPrivateAuctionDeal(PrivateAuctionDealName name) {
        GetPrivateAuctionDealRequest request = GetPrivateAuctionDealRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateAuctionDeal(request);
    }

    public final PrivateAuctionDeal getPrivateAuctionDeal(String name) {
        GetPrivateAuctionDealRequest request = GetPrivateAuctionDealRequest.newBuilder().setName(name).build();
        return this.getPrivateAuctionDeal(request);
    }

    public final PrivateAuctionDeal getPrivateAuctionDeal(GetPrivateAuctionDealRequest request) {
        return (PrivateAuctionDeal)this.getPrivateAuctionDealCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateAuctionDealRequest, PrivateAuctionDeal> getPrivateAuctionDealCallable() {
        return this.stub.getPrivateAuctionDealCallable();
    }

    public final ListPrivateAuctionDealsPagedResponse listPrivateAuctionDeals(NetworkName parent) {
        ListPrivateAuctionDealsRequest request = ListPrivateAuctionDealsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateAuctionDeals(request);
    }

    public final ListPrivateAuctionDealsPagedResponse listPrivateAuctionDeals(String parent) {
        ListPrivateAuctionDealsRequest request = ListPrivateAuctionDealsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateAuctionDeals(request);
    }

    public final ListPrivateAuctionDealsPagedResponse listPrivateAuctionDeals(ListPrivateAuctionDealsRequest request) {
        return (ListPrivateAuctionDealsPagedResponse)((Object)this.listPrivateAuctionDealsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsPagedResponse> listPrivateAuctionDealsPagedCallable() {
        return this.stub.listPrivateAuctionDealsPagedCallable();
    }

    public final UnaryCallable<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse> listPrivateAuctionDealsCallable() {
        return this.stub.listPrivateAuctionDealsCallable();
    }

    public final PrivateAuctionDeal createPrivateAuctionDeal(NetworkName parent, PrivateAuctionDeal privateAuctionDeal) {
        CreatePrivateAuctionDealRequest request = CreatePrivateAuctionDealRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateAuctionDeal(privateAuctionDeal).build();
        return this.createPrivateAuctionDeal(request);
    }

    public final PrivateAuctionDeal createPrivateAuctionDeal(String parent, PrivateAuctionDeal privateAuctionDeal) {
        CreatePrivateAuctionDealRequest request = CreatePrivateAuctionDealRequest.newBuilder().setParent(parent).setPrivateAuctionDeal(privateAuctionDeal).build();
        return this.createPrivateAuctionDeal(request);
    }

    public final PrivateAuctionDeal createPrivateAuctionDeal(CreatePrivateAuctionDealRequest request) {
        return (PrivateAuctionDeal)this.createPrivateAuctionDealCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePrivateAuctionDealRequest, PrivateAuctionDeal> createPrivateAuctionDealCallable() {
        return this.stub.createPrivateAuctionDealCallable();
    }

    public final PrivateAuctionDeal updatePrivateAuctionDeal(PrivateAuctionDeal privateAuctionDeal, FieldMask updateMask) {
        UpdatePrivateAuctionDealRequest request = UpdatePrivateAuctionDealRequest.newBuilder().setPrivateAuctionDeal(privateAuctionDeal).setUpdateMask(updateMask).build();
        return this.updatePrivateAuctionDeal(request);
    }

    public final PrivateAuctionDeal updatePrivateAuctionDeal(UpdatePrivateAuctionDealRequest request) {
        return (PrivateAuctionDeal)this.updatePrivateAuctionDealCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePrivateAuctionDealRequest, PrivateAuctionDeal> updatePrivateAuctionDealCallable() {
        return this.stub.updatePrivateAuctionDealCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPrivateAuctionDealsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal, ListPrivateAuctionDealsPage, ListPrivateAuctionDealsFixedSizeCollection> {
        private ListPrivateAuctionDealsFixedSizeCollection(List<ListPrivateAuctionDealsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateAuctionDealsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateAuctionDealsFixedSizeCollection(null, 0);
        }

        protected ListPrivateAuctionDealsFixedSizeCollection createCollection(List<ListPrivateAuctionDealsPage> pages, int collectionSize) {
            return new ListPrivateAuctionDealsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateAuctionDealsPage
    extends AbstractPage<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal, ListPrivateAuctionDealsPage> {
        private ListPrivateAuctionDealsPage(PageContext<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal> context, ListPrivateAuctionDealsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateAuctionDealsPage createEmptyPage() {
            return new ListPrivateAuctionDealsPage(null, null);
        }

        protected ListPrivateAuctionDealsPage createPage(PageContext<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal> context, ListPrivateAuctionDealsResponse response) {
            return new ListPrivateAuctionDealsPage(context, response);
        }

        public ApiFuture<ListPrivateAuctionDealsPage> createPageAsync(PageContext<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal> context, ApiFuture<ListPrivateAuctionDealsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateAuctionDealsPagedResponse
    extends AbstractPagedListResponse<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal, ListPrivateAuctionDealsPage, ListPrivateAuctionDealsFixedSizeCollection> {
        public static ApiFuture<ListPrivateAuctionDealsPagedResponse> createAsync(PageContext<ListPrivateAuctionDealsRequest, ListPrivateAuctionDealsResponse, PrivateAuctionDeal> context, ApiFuture<ListPrivateAuctionDealsResponse> futureResponse) {
            ApiFuture<ListPrivateAuctionDealsPage> futurePage = ListPrivateAuctionDealsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateAuctionDealsPagedResponse((ListPrivateAuctionDealsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateAuctionDealsPagedResponse(ListPrivateAuctionDealsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateAuctionDealsFixedSizeCollection.createEmptyCollection());
        }
    }
}

