/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetOperatingSystemVersionRequest;
import com.google.ads.admanager.v1.ListOperatingSystemVersionsRequest;
import com.google.ads.admanager.v1.ListOperatingSystemVersionsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.OperatingSystemVersion;
import com.google.ads.admanager.v1.OperatingSystemVersionName;
import com.google.ads.admanager.v1.OperatingSystemVersionServiceSettings;
import com.google.ads.admanager.v1.stub.OperatingSystemVersionServiceStub;
import com.google.ads.admanager.v1.stub.OperatingSystemVersionServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OperatingSystemVersionServiceClient
implements BackgroundResource {
    private final OperatingSystemVersionServiceSettings settings;
    private final OperatingSystemVersionServiceStub stub;

    public static final OperatingSystemVersionServiceClient create() throws IOException {
        return OperatingSystemVersionServiceClient.create(OperatingSystemVersionServiceSettings.newBuilder().build());
    }

    public static final OperatingSystemVersionServiceClient create(OperatingSystemVersionServiceSettings settings) throws IOException {
        return new OperatingSystemVersionServiceClient(settings);
    }

    public static final OperatingSystemVersionServiceClient create(OperatingSystemVersionServiceStub stub) {
        return new OperatingSystemVersionServiceClient(stub);
    }

    protected OperatingSystemVersionServiceClient(OperatingSystemVersionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OperatingSystemVersionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected OperatingSystemVersionServiceClient(OperatingSystemVersionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OperatingSystemVersionServiceSettings getSettings() {
        return this.settings;
    }

    public OperatingSystemVersionServiceStub getStub() {
        return this.stub;
    }

    public final OperatingSystemVersion getOperatingSystemVersion(OperatingSystemVersionName name) {
        GetOperatingSystemVersionRequest request = GetOperatingSystemVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOperatingSystemVersion(request);
    }

    public final OperatingSystemVersion getOperatingSystemVersion(String name) {
        GetOperatingSystemVersionRequest request = GetOperatingSystemVersionRequest.newBuilder().setName(name).build();
        return this.getOperatingSystemVersion(request);
    }

    public final OperatingSystemVersion getOperatingSystemVersion(GetOperatingSystemVersionRequest request) {
        return (OperatingSystemVersion)this.getOperatingSystemVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperatingSystemVersionRequest, OperatingSystemVersion> getOperatingSystemVersionCallable() {
        return this.stub.getOperatingSystemVersionCallable();
    }

    public final ListOperatingSystemVersionsPagedResponse listOperatingSystemVersions(NetworkName parent) {
        ListOperatingSystemVersionsRequest request = ListOperatingSystemVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOperatingSystemVersions(request);
    }

    public final ListOperatingSystemVersionsPagedResponse listOperatingSystemVersions(String parent) {
        ListOperatingSystemVersionsRequest request = ListOperatingSystemVersionsRequest.newBuilder().setParent(parent).build();
        return this.listOperatingSystemVersions(request);
    }

    public final ListOperatingSystemVersionsPagedResponse listOperatingSystemVersions(ListOperatingSystemVersionsRequest request) {
        return (ListOperatingSystemVersionsPagedResponse)((Object)this.listOperatingSystemVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsPagedResponse> listOperatingSystemVersionsPagedCallable() {
        return this.stub.listOperatingSystemVersionsPagedCallable();
    }

    public final UnaryCallable<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse> listOperatingSystemVersionsCallable() {
        return this.stub.listOperatingSystemVersionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListOperatingSystemVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion, ListOperatingSystemVersionsPage, ListOperatingSystemVersionsFixedSizeCollection> {
        private ListOperatingSystemVersionsFixedSizeCollection(List<ListOperatingSystemVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOperatingSystemVersionsFixedSizeCollection createEmptyCollection() {
            return new ListOperatingSystemVersionsFixedSizeCollection(null, 0);
        }

        protected ListOperatingSystemVersionsFixedSizeCollection createCollection(List<ListOperatingSystemVersionsPage> pages, int collectionSize) {
            return new ListOperatingSystemVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOperatingSystemVersionsPage
    extends AbstractPage<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion, ListOperatingSystemVersionsPage> {
        private ListOperatingSystemVersionsPage(PageContext<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion> context, ListOperatingSystemVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListOperatingSystemVersionsPage createEmptyPage() {
            return new ListOperatingSystemVersionsPage(null, null);
        }

        protected ListOperatingSystemVersionsPage createPage(PageContext<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion> context, ListOperatingSystemVersionsResponse response) {
            return new ListOperatingSystemVersionsPage(context, response);
        }

        public ApiFuture<ListOperatingSystemVersionsPage> createPageAsync(PageContext<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion> context, ApiFuture<ListOperatingSystemVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOperatingSystemVersionsPagedResponse
    extends AbstractPagedListResponse<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion, ListOperatingSystemVersionsPage, ListOperatingSystemVersionsFixedSizeCollection> {
        public static ApiFuture<ListOperatingSystemVersionsPagedResponse> createAsync(PageContext<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion> context, ApiFuture<ListOperatingSystemVersionsResponse> futureResponse) {
            ApiFuture<ListOperatingSystemVersionsPage> futurePage = ListOperatingSystemVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOperatingSystemVersionsPagedResponse((ListOperatingSystemVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOperatingSystemVersionsPagedResponse(ListOperatingSystemVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOperatingSystemVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

