/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetMobileDeviceSubmodelRequest;
import com.google.ads.admanager.v1.ListMobileDeviceSubmodelsRequest;
import com.google.ads.admanager.v1.ListMobileDeviceSubmodelsResponse;
import com.google.ads.admanager.v1.MobileDeviceSubmodel;
import com.google.ads.admanager.v1.MobileDeviceSubmodelName;
import com.google.ads.admanager.v1.MobileDeviceSubmodelServiceSettings;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.MobileDeviceSubmodelServiceStub;
import com.google.ads.admanager.v1.stub.MobileDeviceSubmodelServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MobileDeviceSubmodelServiceClient
implements BackgroundResource {
    private final MobileDeviceSubmodelServiceSettings settings;
    private final MobileDeviceSubmodelServiceStub stub;

    public static final MobileDeviceSubmodelServiceClient create() throws IOException {
        return MobileDeviceSubmodelServiceClient.create(MobileDeviceSubmodelServiceSettings.newBuilder().build());
    }

    public static final MobileDeviceSubmodelServiceClient create(MobileDeviceSubmodelServiceSettings settings) throws IOException {
        return new MobileDeviceSubmodelServiceClient(settings);
    }

    public static final MobileDeviceSubmodelServiceClient create(MobileDeviceSubmodelServiceStub stub) {
        return new MobileDeviceSubmodelServiceClient(stub);
    }

    protected MobileDeviceSubmodelServiceClient(MobileDeviceSubmodelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MobileDeviceSubmodelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MobileDeviceSubmodelServiceClient(MobileDeviceSubmodelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MobileDeviceSubmodelServiceSettings getSettings() {
        return this.settings;
    }

    public MobileDeviceSubmodelServiceStub getStub() {
        return this.stub;
    }

    public final MobileDeviceSubmodel getMobileDeviceSubmodel(MobileDeviceSubmodelName name) {
        GetMobileDeviceSubmodelRequest request = GetMobileDeviceSubmodelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMobileDeviceSubmodel(request);
    }

    public final MobileDeviceSubmodel getMobileDeviceSubmodel(String name) {
        GetMobileDeviceSubmodelRequest request = GetMobileDeviceSubmodelRequest.newBuilder().setName(name).build();
        return this.getMobileDeviceSubmodel(request);
    }

    public final MobileDeviceSubmodel getMobileDeviceSubmodel(GetMobileDeviceSubmodelRequest request) {
        return (MobileDeviceSubmodel)this.getMobileDeviceSubmodelCallable().call((Object)request);
    }

    public final UnaryCallable<GetMobileDeviceSubmodelRequest, MobileDeviceSubmodel> getMobileDeviceSubmodelCallable() {
        return this.stub.getMobileDeviceSubmodelCallable();
    }

    public final ListMobileDeviceSubmodelsPagedResponse listMobileDeviceSubmodels(NetworkName parent) {
        ListMobileDeviceSubmodelsRequest request = ListMobileDeviceSubmodelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMobileDeviceSubmodels(request);
    }

    public final ListMobileDeviceSubmodelsPagedResponse listMobileDeviceSubmodels(String parent) {
        ListMobileDeviceSubmodelsRequest request = ListMobileDeviceSubmodelsRequest.newBuilder().setParent(parent).build();
        return this.listMobileDeviceSubmodels(request);
    }

    public final ListMobileDeviceSubmodelsPagedResponse listMobileDeviceSubmodels(ListMobileDeviceSubmodelsRequest request) {
        return (ListMobileDeviceSubmodelsPagedResponse)((Object)this.listMobileDeviceSubmodelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsPagedResponse> listMobileDeviceSubmodelsPagedCallable() {
        return this.stub.listMobileDeviceSubmodelsPagedCallable();
    }

    public final UnaryCallable<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse> listMobileDeviceSubmodelsCallable() {
        return this.stub.listMobileDeviceSubmodelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMobileDeviceSubmodelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel, ListMobileDeviceSubmodelsPage, ListMobileDeviceSubmodelsFixedSizeCollection> {
        private ListMobileDeviceSubmodelsFixedSizeCollection(List<ListMobileDeviceSubmodelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMobileDeviceSubmodelsFixedSizeCollection createEmptyCollection() {
            return new ListMobileDeviceSubmodelsFixedSizeCollection(null, 0);
        }

        protected ListMobileDeviceSubmodelsFixedSizeCollection createCollection(List<ListMobileDeviceSubmodelsPage> pages, int collectionSize) {
            return new ListMobileDeviceSubmodelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMobileDeviceSubmodelsPage
    extends AbstractPage<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel, ListMobileDeviceSubmodelsPage> {
        private ListMobileDeviceSubmodelsPage(PageContext<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel> context, ListMobileDeviceSubmodelsResponse response) {
            super(context, (Object)response);
        }

        private static ListMobileDeviceSubmodelsPage createEmptyPage() {
            return new ListMobileDeviceSubmodelsPage(null, null);
        }

        protected ListMobileDeviceSubmodelsPage createPage(PageContext<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel> context, ListMobileDeviceSubmodelsResponse response) {
            return new ListMobileDeviceSubmodelsPage(context, response);
        }

        public ApiFuture<ListMobileDeviceSubmodelsPage> createPageAsync(PageContext<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel> context, ApiFuture<ListMobileDeviceSubmodelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMobileDeviceSubmodelsPagedResponse
    extends AbstractPagedListResponse<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel, ListMobileDeviceSubmodelsPage, ListMobileDeviceSubmodelsFixedSizeCollection> {
        public static ApiFuture<ListMobileDeviceSubmodelsPagedResponse> createAsync(PageContext<ListMobileDeviceSubmodelsRequest, ListMobileDeviceSubmodelsResponse, MobileDeviceSubmodel> context, ApiFuture<ListMobileDeviceSubmodelsResponse> futureResponse) {
            ApiFuture<ListMobileDeviceSubmodelsPage> futurePage = ListMobileDeviceSubmodelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMobileDeviceSubmodelsPagedResponse((ListMobileDeviceSubmodelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMobileDeviceSubmodelsPagedResponse(ListMobileDeviceSubmodelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMobileDeviceSubmodelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

