/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.DeviceManufacturer;
import com.google.ads.admanager.v1.DeviceManufacturerName;
import com.google.ads.admanager.v1.DeviceManufacturerServiceSettings;
import com.google.ads.admanager.v1.GetDeviceManufacturerRequest;
import com.google.ads.admanager.v1.ListDeviceManufacturersRequest;
import com.google.ads.admanager.v1.ListDeviceManufacturersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.DeviceManufacturerServiceStub;
import com.google.ads.admanager.v1.stub.DeviceManufacturerServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeviceManufacturerServiceClient
implements BackgroundResource {
    private final DeviceManufacturerServiceSettings settings;
    private final DeviceManufacturerServiceStub stub;

    public static final DeviceManufacturerServiceClient create() throws IOException {
        return DeviceManufacturerServiceClient.create(DeviceManufacturerServiceSettings.newBuilder().build());
    }

    public static final DeviceManufacturerServiceClient create(DeviceManufacturerServiceSettings settings) throws IOException {
        return new DeviceManufacturerServiceClient(settings);
    }

    public static final DeviceManufacturerServiceClient create(DeviceManufacturerServiceStub stub) {
        return new DeviceManufacturerServiceClient(stub);
    }

    protected DeviceManufacturerServiceClient(DeviceManufacturerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeviceManufacturerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeviceManufacturerServiceClient(DeviceManufacturerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeviceManufacturerServiceSettings getSettings() {
        return this.settings;
    }

    public DeviceManufacturerServiceStub getStub() {
        return this.stub;
    }

    public final DeviceManufacturer getDeviceManufacturer(DeviceManufacturerName name) {
        GetDeviceManufacturerRequest request = GetDeviceManufacturerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeviceManufacturer(request);
    }

    public final DeviceManufacturer getDeviceManufacturer(String name) {
        GetDeviceManufacturerRequest request = GetDeviceManufacturerRequest.newBuilder().setName(name).build();
        return this.getDeviceManufacturer(request);
    }

    public final DeviceManufacturer getDeviceManufacturer(GetDeviceManufacturerRequest request) {
        return (DeviceManufacturer)this.getDeviceManufacturerCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceManufacturerRequest, DeviceManufacturer> getDeviceManufacturerCallable() {
        return this.stub.getDeviceManufacturerCallable();
    }

    public final ListDeviceManufacturersPagedResponse listDeviceManufacturers(NetworkName parent) {
        ListDeviceManufacturersRequest request = ListDeviceManufacturersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeviceManufacturers(request);
    }

    public final ListDeviceManufacturersPagedResponse listDeviceManufacturers(String parent) {
        ListDeviceManufacturersRequest request = ListDeviceManufacturersRequest.newBuilder().setParent(parent).build();
        return this.listDeviceManufacturers(request);
    }

    public final ListDeviceManufacturersPagedResponse listDeviceManufacturers(ListDeviceManufacturersRequest request) {
        return (ListDeviceManufacturersPagedResponse)((Object)this.listDeviceManufacturersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeviceManufacturersRequest, ListDeviceManufacturersPagedResponse> listDeviceManufacturersPagedCallable() {
        return this.stub.listDeviceManufacturersPagedCallable();
    }

    public final UnaryCallable<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse> listDeviceManufacturersCallable() {
        return this.stub.listDeviceManufacturersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeviceManufacturersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer, ListDeviceManufacturersPage, ListDeviceManufacturersFixedSizeCollection> {
        private ListDeviceManufacturersFixedSizeCollection(List<ListDeviceManufacturersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeviceManufacturersFixedSizeCollection createEmptyCollection() {
            return new ListDeviceManufacturersFixedSizeCollection(null, 0);
        }

        protected ListDeviceManufacturersFixedSizeCollection createCollection(List<ListDeviceManufacturersPage> pages, int collectionSize) {
            return new ListDeviceManufacturersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeviceManufacturersPage
    extends AbstractPage<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer, ListDeviceManufacturersPage> {
        private ListDeviceManufacturersPage(PageContext<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer> context, ListDeviceManufacturersResponse response) {
            super(context, (Object)response);
        }

        private static ListDeviceManufacturersPage createEmptyPage() {
            return new ListDeviceManufacturersPage(null, null);
        }

        protected ListDeviceManufacturersPage createPage(PageContext<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer> context, ListDeviceManufacturersResponse response) {
            return new ListDeviceManufacturersPage(context, response);
        }

        public ApiFuture<ListDeviceManufacturersPage> createPageAsync(PageContext<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer> context, ApiFuture<ListDeviceManufacturersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeviceManufacturersPagedResponse
    extends AbstractPagedListResponse<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer, ListDeviceManufacturersPage, ListDeviceManufacturersFixedSizeCollection> {
        public static ApiFuture<ListDeviceManufacturersPagedResponse> createAsync(PageContext<ListDeviceManufacturersRequest, ListDeviceManufacturersResponse, DeviceManufacturer> context, ApiFuture<ListDeviceManufacturersResponse> futureResponse) {
            ApiFuture<ListDeviceManufacturersPage> futurePage = ListDeviceManufacturersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeviceManufacturersPagedResponse((ListDeviceManufacturersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeviceManufacturersPagedResponse(ListDeviceManufacturersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeviceManufacturersFixedSizeCollection.createEmptyCollection());
        }
    }
}

