/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.DeviceCategory;
import com.google.ads.admanager.v1.DeviceCategoryName;
import com.google.ads.admanager.v1.DeviceCategoryServiceSettings;
import com.google.ads.admanager.v1.GetDeviceCategoryRequest;
import com.google.ads.admanager.v1.ListDeviceCategoriesRequest;
import com.google.ads.admanager.v1.ListDeviceCategoriesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.DeviceCategoryServiceStub;
import com.google.ads.admanager.v1.stub.DeviceCategoryServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeviceCategoryServiceClient
implements BackgroundResource {
    private final DeviceCategoryServiceSettings settings;
    private final DeviceCategoryServiceStub stub;

    public static final DeviceCategoryServiceClient create() throws IOException {
        return DeviceCategoryServiceClient.create(DeviceCategoryServiceSettings.newBuilder().build());
    }

    public static final DeviceCategoryServiceClient create(DeviceCategoryServiceSettings settings) throws IOException {
        return new DeviceCategoryServiceClient(settings);
    }

    public static final DeviceCategoryServiceClient create(DeviceCategoryServiceStub stub) {
        return new DeviceCategoryServiceClient(stub);
    }

    protected DeviceCategoryServiceClient(DeviceCategoryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeviceCategoryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeviceCategoryServiceClient(DeviceCategoryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeviceCategoryServiceSettings getSettings() {
        return this.settings;
    }

    public DeviceCategoryServiceStub getStub() {
        return this.stub;
    }

    public final DeviceCategory getDeviceCategory(DeviceCategoryName name) {
        GetDeviceCategoryRequest request = GetDeviceCategoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeviceCategory(request);
    }

    public final DeviceCategory getDeviceCategory(String name) {
        GetDeviceCategoryRequest request = GetDeviceCategoryRequest.newBuilder().setName(name).build();
        return this.getDeviceCategory(request);
    }

    public final DeviceCategory getDeviceCategory(GetDeviceCategoryRequest request) {
        return (DeviceCategory)this.getDeviceCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeviceCategoryRequest, DeviceCategory> getDeviceCategoryCallable() {
        return this.stub.getDeviceCategoryCallable();
    }

    public final ListDeviceCategoriesPagedResponse listDeviceCategories(NetworkName parent) {
        ListDeviceCategoriesRequest request = ListDeviceCategoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeviceCategories(request);
    }

    public final ListDeviceCategoriesPagedResponse listDeviceCategories(String parent) {
        ListDeviceCategoriesRequest request = ListDeviceCategoriesRequest.newBuilder().setParent(parent).build();
        return this.listDeviceCategories(request);
    }

    public final ListDeviceCategoriesPagedResponse listDeviceCategories(ListDeviceCategoriesRequest request) {
        return (ListDeviceCategoriesPagedResponse)((Object)this.listDeviceCategoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeviceCategoriesRequest, ListDeviceCategoriesPagedResponse> listDeviceCategoriesPagedCallable() {
        return this.stub.listDeviceCategoriesPagedCallable();
    }

    public final UnaryCallable<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse> listDeviceCategoriesCallable() {
        return this.stub.listDeviceCategoriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeviceCategoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory, ListDeviceCategoriesPage, ListDeviceCategoriesFixedSizeCollection> {
        private ListDeviceCategoriesFixedSizeCollection(List<ListDeviceCategoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeviceCategoriesFixedSizeCollection createEmptyCollection() {
            return new ListDeviceCategoriesFixedSizeCollection(null, 0);
        }

        protected ListDeviceCategoriesFixedSizeCollection createCollection(List<ListDeviceCategoriesPage> pages, int collectionSize) {
            return new ListDeviceCategoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeviceCategoriesPage
    extends AbstractPage<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory, ListDeviceCategoriesPage> {
        private ListDeviceCategoriesPage(PageContext<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory> context, ListDeviceCategoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeviceCategoriesPage createEmptyPage() {
            return new ListDeviceCategoriesPage(null, null);
        }

        protected ListDeviceCategoriesPage createPage(PageContext<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory> context, ListDeviceCategoriesResponse response) {
            return new ListDeviceCategoriesPage(context, response);
        }

        public ApiFuture<ListDeviceCategoriesPage> createPageAsync(PageContext<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory> context, ApiFuture<ListDeviceCategoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeviceCategoriesPagedResponse
    extends AbstractPagedListResponse<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory, ListDeviceCategoriesPage, ListDeviceCategoriesFixedSizeCollection> {
        public static ApiFuture<ListDeviceCategoriesPagedResponse> createAsync(PageContext<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory> context, ApiFuture<ListDeviceCategoriesResponse> futureResponse) {
            ApiFuture<ListDeviceCategoriesPage> futurePage = ListDeviceCategoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeviceCategoriesPagedResponse((ListDeviceCategoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeviceCategoriesPagedResponse(ListDeviceCategoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeviceCategoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

