/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.ContentBundle;
import com.google.ads.admanager.v1.ContentBundleName;
import com.google.ads.admanager.v1.ContentBundleServiceSettings;
import com.google.ads.admanager.v1.GetContentBundleRequest;
import com.google.ads.admanager.v1.ListContentBundlesRequest;
import com.google.ads.admanager.v1.ListContentBundlesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.ContentBundleServiceStub;
import com.google.ads.admanager.v1.stub.ContentBundleServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContentBundleServiceClient
implements BackgroundResource {
    private final ContentBundleServiceSettings settings;
    private final ContentBundleServiceStub stub;

    public static final ContentBundleServiceClient create() throws IOException {
        return ContentBundleServiceClient.create(ContentBundleServiceSettings.newBuilder().build());
    }

    public static final ContentBundleServiceClient create(ContentBundleServiceSettings settings) throws IOException {
        return new ContentBundleServiceClient(settings);
    }

    public static final ContentBundleServiceClient create(ContentBundleServiceStub stub) {
        return new ContentBundleServiceClient(stub);
    }

    protected ContentBundleServiceClient(ContentBundleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContentBundleServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ContentBundleServiceClient(ContentBundleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContentBundleServiceSettings getSettings() {
        return this.settings;
    }

    public ContentBundleServiceStub getStub() {
        return this.stub;
    }

    public final ContentBundle getContentBundle(ContentBundleName name) {
        GetContentBundleRequest request = GetContentBundleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContentBundle(request);
    }

    public final ContentBundle getContentBundle(String name) {
        GetContentBundleRequest request = GetContentBundleRequest.newBuilder().setName(name).build();
        return this.getContentBundle(request);
    }

    public final ContentBundle getContentBundle(GetContentBundleRequest request) {
        return (ContentBundle)this.getContentBundleCallable().call((Object)request);
    }

    public final UnaryCallable<GetContentBundleRequest, ContentBundle> getContentBundleCallable() {
        return this.stub.getContentBundleCallable();
    }

    public final ListContentBundlesPagedResponse listContentBundles(NetworkName parent) {
        ListContentBundlesRequest request = ListContentBundlesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContentBundles(request);
    }

    public final ListContentBundlesPagedResponse listContentBundles(String parent) {
        ListContentBundlesRequest request = ListContentBundlesRequest.newBuilder().setParent(parent).build();
        return this.listContentBundles(request);
    }

    public final ListContentBundlesPagedResponse listContentBundles(ListContentBundlesRequest request) {
        return (ListContentBundlesPagedResponse)((Object)this.listContentBundlesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContentBundlesRequest, ListContentBundlesPagedResponse> listContentBundlesPagedCallable() {
        return this.stub.listContentBundlesPagedCallable();
    }

    public final UnaryCallable<ListContentBundlesRequest, ListContentBundlesResponse> listContentBundlesCallable() {
        return this.stub.listContentBundlesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListContentBundlesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle, ListContentBundlesPage, ListContentBundlesFixedSizeCollection> {
        private ListContentBundlesFixedSizeCollection(List<ListContentBundlesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContentBundlesFixedSizeCollection createEmptyCollection() {
            return new ListContentBundlesFixedSizeCollection(null, 0);
        }

        protected ListContentBundlesFixedSizeCollection createCollection(List<ListContentBundlesPage> pages, int collectionSize) {
            return new ListContentBundlesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContentBundlesPage
    extends AbstractPage<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle, ListContentBundlesPage> {
        private ListContentBundlesPage(PageContext<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle> context, ListContentBundlesResponse response) {
            super(context, (Object)response);
        }

        private static ListContentBundlesPage createEmptyPage() {
            return new ListContentBundlesPage(null, null);
        }

        protected ListContentBundlesPage createPage(PageContext<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle> context, ListContentBundlesResponse response) {
            return new ListContentBundlesPage(context, response);
        }

        public ApiFuture<ListContentBundlesPage> createPageAsync(PageContext<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle> context, ApiFuture<ListContentBundlesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContentBundlesPagedResponse
    extends AbstractPagedListResponse<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle, ListContentBundlesPage, ListContentBundlesFixedSizeCollection> {
        public static ApiFuture<ListContentBundlesPagedResponse> createAsync(PageContext<ListContentBundlesRequest, ListContentBundlesResponse, ContentBundle> context, ApiFuture<ListContentBundlesResponse> futureResponse) {
            ApiFuture<ListContentBundlesPage> futurePage = ListContentBundlesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContentBundlesPagedResponse((ListContentBundlesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContentBundlesPagedResponse(ListContentBundlesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContentBundlesFixedSizeCollection.createEmptyCollection());
        }
    }
}

