/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchActivatePlacementsRequest;
import com.google.ads.admanager.v1.BatchActivatePlacementsResponse;
import com.google.ads.admanager.v1.BatchArchivePlacementsRequest;
import com.google.ads.admanager.v1.BatchArchivePlacementsResponse;
import com.google.ads.admanager.v1.BatchCreatePlacementsRequest;
import com.google.ads.admanager.v1.BatchCreatePlacementsResponse;
import com.google.ads.admanager.v1.BatchDeactivatePlacementsRequest;
import com.google.ads.admanager.v1.BatchDeactivatePlacementsResponse;
import com.google.ads.admanager.v1.BatchUpdatePlacementsRequest;
import com.google.ads.admanager.v1.BatchUpdatePlacementsResponse;
import com.google.ads.admanager.v1.CreatePlacementRequest;
import com.google.ads.admanager.v1.GetPlacementRequest;
import com.google.ads.admanager.v1.ListPlacementsRequest;
import com.google.ads.admanager.v1.ListPlacementsResponse;
import com.google.ads.admanager.v1.Placement;
import com.google.ads.admanager.v1.PlacementServiceClient;
import com.google.ads.admanager.v1.UpdatePlacementRequest;
import com.google.ads.admanager.v1.stub.HttpJsonPlacementServiceStub;
import com.google.ads.admanager.v1.stub.PlacementServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PlacementServiceStubSettings
extends StubSettings<PlacementServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetPlacementRequest, Placement> getPlacementSettings;
    private final PagedCallSettings<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse> listPlacementsSettings;
    private final UnaryCallSettings<CreatePlacementRequest, Placement> createPlacementSettings;
    private final UnaryCallSettings<UpdatePlacementRequest, Placement> updatePlacementSettings;
    private final UnaryCallSettings<BatchCreatePlacementsRequest, BatchCreatePlacementsResponse> batchCreatePlacementsSettings;
    private final UnaryCallSettings<BatchUpdatePlacementsRequest, BatchUpdatePlacementsResponse> batchUpdatePlacementsSettings;
    private final UnaryCallSettings<BatchActivatePlacementsRequest, BatchActivatePlacementsResponse> batchActivatePlacementsSettings;
    private final UnaryCallSettings<BatchDeactivatePlacementsRequest, BatchDeactivatePlacementsResponse> batchDeactivatePlacementsSettings;
    private final UnaryCallSettings<BatchArchivePlacementsRequest, BatchArchivePlacementsResponse> batchArchivePlacementsSettings;
    private static final PagedListDescriptor<ListPlacementsRequest, ListPlacementsResponse, Placement> LIST_PLACEMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListPlacementsRequest, ListPlacementsResponse, Placement>(){

        public String emptyToken() {
            return "";
        }

        public ListPlacementsRequest injectToken(ListPlacementsRequest payload, String token) {
            return ListPlacementsRequest.newBuilder((ListPlacementsRequest)payload).setPageToken(token).build();
        }

        public ListPlacementsRequest injectPageSize(ListPlacementsRequest payload, int pageSize) {
            return ListPlacementsRequest.newBuilder((ListPlacementsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPlacementsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPlacementsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Placement> extractResources(ListPlacementsResponse payload) {
            return payload.getPlacementsList();
        }
    };
    private static final PagedListResponseFactory<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse> LIST_PLACEMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse>(){

        public ApiFuture<PlacementServiceClient.ListPlacementsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPlacementsRequest, ListPlacementsResponse> callable, ListPlacementsRequest request, ApiCallContext context, ApiFuture<ListPlacementsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PLACEMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PlacementServiceClient.ListPlacementsPagedResponse.createAsync((PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetPlacementRequest, Placement> getPlacementSettings() {
        return this.getPlacementSettings;
    }

    public PagedCallSettings<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse> listPlacementsSettings() {
        return this.listPlacementsSettings;
    }

    public UnaryCallSettings<CreatePlacementRequest, Placement> createPlacementSettings() {
        return this.createPlacementSettings;
    }

    public UnaryCallSettings<UpdatePlacementRequest, Placement> updatePlacementSettings() {
        return this.updatePlacementSettings;
    }

    public UnaryCallSettings<BatchCreatePlacementsRequest, BatchCreatePlacementsResponse> batchCreatePlacementsSettings() {
        return this.batchCreatePlacementsSettings;
    }

    public UnaryCallSettings<BatchUpdatePlacementsRequest, BatchUpdatePlacementsResponse> batchUpdatePlacementsSettings() {
        return this.batchUpdatePlacementsSettings;
    }

    public UnaryCallSettings<BatchActivatePlacementsRequest, BatchActivatePlacementsResponse> batchActivatePlacementsSettings() {
        return this.batchActivatePlacementsSettings;
    }

    public UnaryCallSettings<BatchDeactivatePlacementsRequest, BatchDeactivatePlacementsResponse> batchDeactivatePlacementsSettings() {
        return this.batchDeactivatePlacementsSettings;
    }

    public UnaryCallSettings<BatchArchivePlacementsRequest, BatchArchivePlacementsResponse> batchArchivePlacementsSettings() {
        return this.batchArchivePlacementsSettings;
    }

    public PlacementServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPlacementServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PlacementServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PlacementServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PlacementServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getPlacementSettings = settingsBuilder.getPlacementSettings().build();
        this.listPlacementsSettings = settingsBuilder.listPlacementsSettings().build();
        this.createPlacementSettings = settingsBuilder.createPlacementSettings().build();
        this.updatePlacementSettings = settingsBuilder.updatePlacementSettings().build();
        this.batchCreatePlacementsSettings = settingsBuilder.batchCreatePlacementsSettings().build();
        this.batchUpdatePlacementsSettings = settingsBuilder.batchUpdatePlacementsSettings().build();
        this.batchActivatePlacementsSettings = settingsBuilder.batchActivatePlacementsSettings().build();
        this.batchDeactivatePlacementsSettings = settingsBuilder.batchDeactivatePlacementsSettings().build();
        this.batchArchivePlacementsSettings = settingsBuilder.batchArchivePlacementsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PlacementServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetPlacementRequest, Placement> getPlacementSettings;
        private final PagedCallSettings.Builder<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse> listPlacementsSettings;
        private final UnaryCallSettings.Builder<CreatePlacementRequest, Placement> createPlacementSettings;
        private final UnaryCallSettings.Builder<UpdatePlacementRequest, Placement> updatePlacementSettings;
        private final UnaryCallSettings.Builder<BatchCreatePlacementsRequest, BatchCreatePlacementsResponse> batchCreatePlacementsSettings;
        private final UnaryCallSettings.Builder<BatchUpdatePlacementsRequest, BatchUpdatePlacementsResponse> batchUpdatePlacementsSettings;
        private final UnaryCallSettings.Builder<BatchActivatePlacementsRequest, BatchActivatePlacementsResponse> batchActivatePlacementsSettings;
        private final UnaryCallSettings.Builder<BatchDeactivatePlacementsRequest, BatchDeactivatePlacementsResponse> batchDeactivatePlacementsSettings;
        private final UnaryCallSettings.Builder<BatchArchivePlacementsRequest, BatchArchivePlacementsResponse> batchArchivePlacementsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getPlacementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlacementsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PLACEMENTS_PAGE_STR_FACT);
            this.createPlacementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePlacementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreatePlacementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdatePlacementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchActivatePlacementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeactivatePlacementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchArchivePlacementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPlacementSettings, this.listPlacementsSettings, this.createPlacementSettings, this.updatePlacementSettings, this.batchCreatePlacementsSettings, this.batchUpdatePlacementsSettings, this.batchActivatePlacementsSettings, this.batchDeactivatePlacementsSettings, this.batchArchivePlacementsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PlacementServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getPlacementSettings = settings.getPlacementSettings.toBuilder();
            this.listPlacementsSettings = settings.listPlacementsSettings.toBuilder();
            this.createPlacementSettings = settings.createPlacementSettings.toBuilder();
            this.updatePlacementSettings = settings.updatePlacementSettings.toBuilder();
            this.batchCreatePlacementsSettings = settings.batchCreatePlacementsSettings.toBuilder();
            this.batchUpdatePlacementsSettings = settings.batchUpdatePlacementsSettings.toBuilder();
            this.batchActivatePlacementsSettings = settings.batchActivatePlacementsSettings.toBuilder();
            this.batchDeactivatePlacementsSettings = settings.batchDeactivatePlacementsSettings.toBuilder();
            this.batchArchivePlacementsSettings = settings.batchArchivePlacementsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPlacementSettings, this.listPlacementsSettings, this.createPlacementSettings, this.updatePlacementSettings, this.batchCreatePlacementsSettings, this.batchUpdatePlacementsSettings, this.batchActivatePlacementsSettings, this.batchDeactivatePlacementsSettings, this.batchArchivePlacementsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PlacementServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PlacementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PlacementServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PlacementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getPlacementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createPlacementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updatePlacementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreatePlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdatePlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchActivatePlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchDeactivatePlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchArchivePlacementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetPlacementRequest, Placement> getPlacementSettings() {
            return this.getPlacementSettings;
        }

        public PagedCallSettings.Builder<ListPlacementsRequest, ListPlacementsResponse, PlacementServiceClient.ListPlacementsPagedResponse> listPlacementsSettings() {
            return this.listPlacementsSettings;
        }

        public UnaryCallSettings.Builder<CreatePlacementRequest, Placement> createPlacementSettings() {
            return this.createPlacementSettings;
        }

        public UnaryCallSettings.Builder<UpdatePlacementRequest, Placement> updatePlacementSettings() {
            return this.updatePlacementSettings;
        }

        public UnaryCallSettings.Builder<BatchCreatePlacementsRequest, BatchCreatePlacementsResponse> batchCreatePlacementsSettings() {
            return this.batchCreatePlacementsSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdatePlacementsRequest, BatchUpdatePlacementsResponse> batchUpdatePlacementsSettings() {
            return this.batchUpdatePlacementsSettings;
        }

        public UnaryCallSettings.Builder<BatchActivatePlacementsRequest, BatchActivatePlacementsResponse> batchActivatePlacementsSettings() {
            return this.batchActivatePlacementsSettings;
        }

        public UnaryCallSettings.Builder<BatchDeactivatePlacementsRequest, BatchDeactivatePlacementsResponse> batchDeactivatePlacementsSettings() {
            return this.batchDeactivatePlacementsSettings;
        }

        public UnaryCallSettings.Builder<BatchArchivePlacementsRequest, BatchArchivePlacementsResponse> batchArchivePlacementsSettings() {
            return this.batchArchivePlacementsSettings;
        }

        public PlacementServiceStubSettings build() throws IOException {
            return new PlacementServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

