/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.ContentLabel;
import com.google.ads.admanager.v1.ContentLabelServiceClient;
import com.google.ads.admanager.v1.GetContentLabelRequest;
import com.google.ads.admanager.v1.ListContentLabelsRequest;
import com.google.ads.admanager.v1.ListContentLabelsResponse;
import com.google.ads.admanager.v1.stub.ContentLabelServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonContentLabelServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ContentLabelServiceStubSettings
extends StubSettings<ContentLabelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetContentLabelRequest, ContentLabel> getContentLabelSettings;
    private final PagedCallSettings<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsSettings;
    private static final PagedListDescriptor<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel> LIST_CONTENT_LABELS_PAGE_STR_DESC = new PagedListDescriptor<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel>(){

        public String emptyToken() {
            return "";
        }

        public ListContentLabelsRequest injectToken(ListContentLabelsRequest payload, String token) {
            return ListContentLabelsRequest.newBuilder((ListContentLabelsRequest)payload).setPageToken(token).build();
        }

        public ListContentLabelsRequest injectPageSize(ListContentLabelsRequest payload, int pageSize) {
            return ListContentLabelsRequest.newBuilder((ListContentLabelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContentLabelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContentLabelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ContentLabel> extractResources(ListContentLabelsResponse payload) {
            return payload.getContentLabelsList();
        }
    };
    private static final PagedListResponseFactory<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse> LIST_CONTENT_LABELS_PAGE_STR_FACT = new PagedListResponseFactory<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse>(){

        public ApiFuture<ContentLabelServiceClient.ListContentLabelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListContentLabelsRequest, ListContentLabelsResponse> callable, ListContentLabelsRequest request, ApiCallContext context, ApiFuture<ListContentLabelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTENT_LABELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ContentLabelServiceClient.ListContentLabelsPagedResponse.createAsync((PageContext<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabel>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetContentLabelRequest, ContentLabel> getContentLabelSettings() {
        return this.getContentLabelSettings;
    }

    public PagedCallSettings<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsSettings() {
        return this.listContentLabelsSettings;
    }

    public ContentLabelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonContentLabelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContentLabelServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContentLabelServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContentLabelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getContentLabelSettings = settingsBuilder.getContentLabelSettings().build();
        this.listContentLabelsSettings = settingsBuilder.listContentLabelsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContentLabelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetContentLabelRequest, ContentLabel> getContentLabelSettings;
        private final PagedCallSettings.Builder<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getContentLabelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listContentLabelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTENT_LABELS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContentLabelSettings, this.listContentLabelsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContentLabelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getContentLabelSettings = settings.getContentLabelSettings.toBuilder();
            this.listContentLabelsSettings = settings.listContentLabelsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContentLabelSettings, this.listContentLabelsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContentLabelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContentLabelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContentLabelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ContentLabelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getContentLabelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listContentLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetContentLabelRequest, ContentLabel> getContentLabelSettings() {
            return this.getContentLabelSettings;
        }

        public PagedCallSettings.Builder<ListContentLabelsRequest, ListContentLabelsResponse, ContentLabelServiceClient.ListContentLabelsPagedResponse> listContentLabelsSettings() {
            return this.listContentLabelsSettings;
        }

        public ContentLabelServiceStubSettings build() throws IOException {
            return new ContentLabelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

