/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetRoleRequest;
import com.google.ads.admanager.v1.ListRolesRequest;
import com.google.ads.admanager.v1.ListRolesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Role;
import com.google.ads.admanager.v1.RoleName;
import com.google.ads.admanager.v1.RoleServiceSettings;
import com.google.ads.admanager.v1.stub.RoleServiceStub;
import com.google.ads.admanager.v1.stub.RoleServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RoleServiceClient
implements BackgroundResource {
    private final RoleServiceSettings settings;
    private final RoleServiceStub stub;

    public static final RoleServiceClient create() throws IOException {
        return RoleServiceClient.create(RoleServiceSettings.newBuilder().build());
    }

    public static final RoleServiceClient create(RoleServiceSettings settings) throws IOException {
        return new RoleServiceClient(settings);
    }

    public static final RoleServiceClient create(RoleServiceStub stub) {
        return new RoleServiceClient(stub);
    }

    protected RoleServiceClient(RoleServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoleServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected RoleServiceClient(RoleServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoleServiceSettings getSettings() {
        return this.settings;
    }

    public RoleServiceStub getStub() {
        return this.stub;
    }

    public final Role getRole(RoleName name) {
        GetRoleRequest request = GetRoleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRole(request);
    }

    public final Role getRole(String name) {
        GetRoleRequest request = GetRoleRequest.newBuilder().setName(name).build();
        return this.getRole(request);
    }

    public final Role getRole(GetRoleRequest request) {
        return (Role)this.getRoleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRoleRequest, Role> getRoleCallable() {
        return this.stub.getRoleCallable();
    }

    public final ListRolesPagedResponse listRoles(NetworkName parent) {
        ListRolesRequest request = ListRolesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRoles(request);
    }

    public final ListRolesPagedResponse listRoles(String parent) {
        ListRolesRequest request = ListRolesRequest.newBuilder().setParent(parent).build();
        return this.listRoles(request);
    }

    public final ListRolesPagedResponse listRoles(ListRolesRequest request) {
        return (ListRolesPagedResponse)((Object)this.listRolesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRolesRequest, ListRolesPagedResponse> listRolesPagedCallable() {
        return this.stub.listRolesPagedCallable();
    }

    public final UnaryCallable<ListRolesRequest, ListRolesResponse> listRolesCallable() {
        return this.stub.listRolesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRolesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRolesRequest, ListRolesResponse, Role, ListRolesPage, ListRolesFixedSizeCollection> {
        private ListRolesFixedSizeCollection(List<ListRolesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRolesFixedSizeCollection createEmptyCollection() {
            return new ListRolesFixedSizeCollection(null, 0);
        }

        protected ListRolesFixedSizeCollection createCollection(List<ListRolesPage> pages, int collectionSize) {
            return new ListRolesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRolesPage
    extends AbstractPage<ListRolesRequest, ListRolesResponse, Role, ListRolesPage> {
        private ListRolesPage(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ListRolesResponse response) {
            super(context, (Object)response);
        }

        private static ListRolesPage createEmptyPage() {
            return new ListRolesPage(null, null);
        }

        protected ListRolesPage createPage(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ListRolesResponse response) {
            return new ListRolesPage(context, response);
        }

        public ApiFuture<ListRolesPage> createPageAsync(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ApiFuture<ListRolesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRolesPagedResponse
    extends AbstractPagedListResponse<ListRolesRequest, ListRolesResponse, Role, ListRolesPage, ListRolesFixedSizeCollection> {
        public static ApiFuture<ListRolesPagedResponse> createAsync(PageContext<ListRolesRequest, ListRolesResponse, Role> context, ApiFuture<ListRolesResponse> futureResponse) {
            ApiFuture<ListRolesPage> futurePage = ListRolesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRolesPagedResponse((ListRolesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRolesPagedResponse(ListRolesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRolesFixedSizeCollection.createEmptyCollection());
        }
    }
}

