/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GeoTarget;
import com.google.ads.admanager.v1.GeoTargetName;
import com.google.ads.admanager.v1.GeoTargetServiceSettings;
import com.google.ads.admanager.v1.GetGeoTargetRequest;
import com.google.ads.admanager.v1.ListGeoTargetsRequest;
import com.google.ads.admanager.v1.ListGeoTargetsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.GeoTargetServiceStub;
import com.google.ads.admanager.v1.stub.GeoTargetServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GeoTargetServiceClient
implements BackgroundResource {
    private final GeoTargetServiceSettings settings;
    private final GeoTargetServiceStub stub;

    public static final GeoTargetServiceClient create() throws IOException {
        return GeoTargetServiceClient.create(GeoTargetServiceSettings.newBuilder().build());
    }

    public static final GeoTargetServiceClient create(GeoTargetServiceSettings settings) throws IOException {
        return new GeoTargetServiceClient(settings);
    }

    public static final GeoTargetServiceClient create(GeoTargetServiceStub stub) {
        return new GeoTargetServiceClient(stub);
    }

    protected GeoTargetServiceClient(GeoTargetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GeoTargetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GeoTargetServiceClient(GeoTargetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GeoTargetServiceSettings getSettings() {
        return this.settings;
    }

    public GeoTargetServiceStub getStub() {
        return this.stub;
    }

    public final GeoTarget getGeoTarget(GeoTargetName name) {
        GetGeoTargetRequest request = GetGeoTargetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGeoTarget(request);
    }

    public final GeoTarget getGeoTarget(String name) {
        GetGeoTargetRequest request = GetGeoTargetRequest.newBuilder().setName(name).build();
        return this.getGeoTarget(request);
    }

    public final GeoTarget getGeoTarget(GetGeoTargetRequest request) {
        return (GeoTarget)this.getGeoTargetCallable().call((Object)request);
    }

    public final UnaryCallable<GetGeoTargetRequest, GeoTarget> getGeoTargetCallable() {
        return this.stub.getGeoTargetCallable();
    }

    public final ListGeoTargetsPagedResponse listGeoTargets(NetworkName parent) {
        ListGeoTargetsRequest request = ListGeoTargetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGeoTargets(request);
    }

    public final ListGeoTargetsPagedResponse listGeoTargets(String parent) {
        ListGeoTargetsRequest request = ListGeoTargetsRequest.newBuilder().setParent(parent).build();
        return this.listGeoTargets(request);
    }

    public final ListGeoTargetsPagedResponse listGeoTargets(ListGeoTargetsRequest request) {
        return (ListGeoTargetsPagedResponse)((Object)this.listGeoTargetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGeoTargetsRequest, ListGeoTargetsPagedResponse> listGeoTargetsPagedCallable() {
        return this.stub.listGeoTargetsPagedCallable();
    }

    public final UnaryCallable<ListGeoTargetsRequest, ListGeoTargetsResponse> listGeoTargetsCallable() {
        return this.stub.listGeoTargetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGeoTargetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget, ListGeoTargetsPage, ListGeoTargetsFixedSizeCollection> {
        private ListGeoTargetsFixedSizeCollection(List<ListGeoTargetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGeoTargetsFixedSizeCollection createEmptyCollection() {
            return new ListGeoTargetsFixedSizeCollection(null, 0);
        }

        protected ListGeoTargetsFixedSizeCollection createCollection(List<ListGeoTargetsPage> pages, int collectionSize) {
            return new ListGeoTargetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGeoTargetsPage
    extends AbstractPage<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget, ListGeoTargetsPage> {
        private ListGeoTargetsPage(PageContext<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget> context, ListGeoTargetsResponse response) {
            super(context, (Object)response);
        }

        private static ListGeoTargetsPage createEmptyPage() {
            return new ListGeoTargetsPage(null, null);
        }

        protected ListGeoTargetsPage createPage(PageContext<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget> context, ListGeoTargetsResponse response) {
            return new ListGeoTargetsPage(context, response);
        }

        public ApiFuture<ListGeoTargetsPage> createPageAsync(PageContext<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget> context, ApiFuture<ListGeoTargetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGeoTargetsPagedResponse
    extends AbstractPagedListResponse<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget, ListGeoTargetsPage, ListGeoTargetsFixedSizeCollection> {
        public static ApiFuture<ListGeoTargetsPagedResponse> createAsync(PageContext<ListGeoTargetsRequest, ListGeoTargetsResponse, GeoTarget> context, ApiFuture<ListGeoTargetsResponse> futureResponse) {
            ApiFuture<ListGeoTargetsPage> futurePage = ListGeoTargetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGeoTargetsPagedResponse((ListGeoTargetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGeoTargetsPagedResponse(ListGeoTargetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGeoTargetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

