/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetOperatingSystemRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsRequest;
import com.google.ads.admanager.v1.ListOperatingSystemsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.OperatingSystem;
import com.google.ads.admanager.v1.OperatingSystemName;
import com.google.ads.admanager.v1.OperatingSystemServiceSettings;
import com.google.ads.admanager.v1.stub.OperatingSystemServiceStub;
import com.google.ads.admanager.v1.stub.OperatingSystemServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OperatingSystemServiceClient
implements BackgroundResource {
    private final OperatingSystemServiceSettings settings;
    private final OperatingSystemServiceStub stub;

    public static final OperatingSystemServiceClient create() throws IOException {
        return OperatingSystemServiceClient.create(OperatingSystemServiceSettings.newBuilder().build());
    }

    public static final OperatingSystemServiceClient create(OperatingSystemServiceSettings settings) throws IOException {
        return new OperatingSystemServiceClient(settings);
    }

    public static final OperatingSystemServiceClient create(OperatingSystemServiceStub stub) {
        return new OperatingSystemServiceClient(stub);
    }

    protected OperatingSystemServiceClient(OperatingSystemServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OperatingSystemServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected OperatingSystemServiceClient(OperatingSystemServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OperatingSystemServiceSettings getSettings() {
        return this.settings;
    }

    public OperatingSystemServiceStub getStub() {
        return this.stub;
    }

    public final OperatingSystem getOperatingSystem(OperatingSystemName name) {
        GetOperatingSystemRequest request = GetOperatingSystemRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOperatingSystem(request);
    }

    public final OperatingSystem getOperatingSystem(String name) {
        GetOperatingSystemRequest request = GetOperatingSystemRequest.newBuilder().setName(name).build();
        return this.getOperatingSystem(request);
    }

    public final OperatingSystem getOperatingSystem(GetOperatingSystemRequest request) {
        return (OperatingSystem)this.getOperatingSystemCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperatingSystemRequest, OperatingSystem> getOperatingSystemCallable() {
        return this.stub.getOperatingSystemCallable();
    }

    public final ListOperatingSystemsPagedResponse listOperatingSystems(NetworkName parent) {
        ListOperatingSystemsRequest request = ListOperatingSystemsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOperatingSystems(request);
    }

    public final ListOperatingSystemsPagedResponse listOperatingSystems(String parent) {
        ListOperatingSystemsRequest request = ListOperatingSystemsRequest.newBuilder().setParent(parent).build();
        return this.listOperatingSystems(request);
    }

    public final ListOperatingSystemsPagedResponse listOperatingSystems(ListOperatingSystemsRequest request) {
        return (ListOperatingSystemsPagedResponse)((Object)this.listOperatingSystemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOperatingSystemsRequest, ListOperatingSystemsPagedResponse> listOperatingSystemsPagedCallable() {
        return this.stub.listOperatingSystemsPagedCallable();
    }

    public final UnaryCallable<ListOperatingSystemsRequest, ListOperatingSystemsResponse> listOperatingSystemsCallable() {
        return this.stub.listOperatingSystemsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListOperatingSystemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem, ListOperatingSystemsPage, ListOperatingSystemsFixedSizeCollection> {
        private ListOperatingSystemsFixedSizeCollection(List<ListOperatingSystemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOperatingSystemsFixedSizeCollection createEmptyCollection() {
            return new ListOperatingSystemsFixedSizeCollection(null, 0);
        }

        protected ListOperatingSystemsFixedSizeCollection createCollection(List<ListOperatingSystemsPage> pages, int collectionSize) {
            return new ListOperatingSystemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOperatingSystemsPage
    extends AbstractPage<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem, ListOperatingSystemsPage> {
        private ListOperatingSystemsPage(PageContext<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem> context, ListOperatingSystemsResponse response) {
            super(context, (Object)response);
        }

        private static ListOperatingSystemsPage createEmptyPage() {
            return new ListOperatingSystemsPage(null, null);
        }

        protected ListOperatingSystemsPage createPage(PageContext<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem> context, ListOperatingSystemsResponse response) {
            return new ListOperatingSystemsPage(context, response);
        }

        public ApiFuture<ListOperatingSystemsPage> createPageAsync(PageContext<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem> context, ApiFuture<ListOperatingSystemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOperatingSystemsPagedResponse
    extends AbstractPagedListResponse<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem, ListOperatingSystemsPage, ListOperatingSystemsFixedSizeCollection> {
        public static ApiFuture<ListOperatingSystemsPagedResponse> createAsync(PageContext<ListOperatingSystemsRequest, ListOperatingSystemsResponse, OperatingSystem> context, ApiFuture<ListOperatingSystemsResponse> futureResponse) {
            ApiFuture<ListOperatingSystemsPage> futurePage = ListOperatingSystemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOperatingSystemsPagedResponse((ListOperatingSystemsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOperatingSystemsPagedResponse(ListOperatingSystemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOperatingSystemsFixedSizeCollection.createEmptyCollection());
        }
    }
}

