/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetRoleRequest;
import com.google.ads.admanager.v1.ListRolesRequest;
import com.google.ads.admanager.v1.ListRolesResponse;
import com.google.ads.admanager.v1.Role;
import com.google.ads.admanager.v1.RoleServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonRoleServiceStub;
import com.google.ads.admanager.v1.stub.RoleServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RoleServiceStubSettings
extends StubSettings<RoleServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetRoleRequest, Role> getRoleSettings;
    private final PagedCallSettings<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse> listRolesSettings;
    private static final PagedListDescriptor<ListRolesRequest, ListRolesResponse, Role> LIST_ROLES_PAGE_STR_DESC = new PagedListDescriptor<ListRolesRequest, ListRolesResponse, Role>(){

        public String emptyToken() {
            return "";
        }

        public ListRolesRequest injectToken(ListRolesRequest payload, String token) {
            return ListRolesRequest.newBuilder((ListRolesRequest)payload).setPageToken(token).build();
        }

        public ListRolesRequest injectPageSize(ListRolesRequest payload, int pageSize) {
            return ListRolesRequest.newBuilder((ListRolesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRolesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRolesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Role> extractResources(ListRolesResponse payload) {
            return payload.getRolesList();
        }
    };
    private static final PagedListResponseFactory<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse> LIST_ROLES_PAGE_STR_FACT = new PagedListResponseFactory<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse>(){

        public ApiFuture<RoleServiceClient.ListRolesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRolesRequest, ListRolesResponse> callable, ListRolesRequest request, ApiCallContext context, ApiFuture<ListRolesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoleServiceClient.ListRolesPagedResponse.createAsync((PageContext<ListRolesRequest, ListRolesResponse, Role>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetRoleRequest, Role> getRoleSettings() {
        return this.getRoleSettings;
    }

    public PagedCallSettings<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse> listRolesSettings() {
        return this.listRolesSettings;
    }

    public RoleServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRoleServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RoleServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RoleServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RoleServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getRoleSettings = settingsBuilder.getRoleSettings().build();
        this.listRolesSettings = settingsBuilder.listRolesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RoleServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetRoleRequest, Role> getRoleSettings;
        private final PagedCallSettings.Builder<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse> listRolesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRolesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROLES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRoleSettings, this.listRolesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RoleServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getRoleSettings = settings.getRoleSettings.toBuilder();
            this.listRolesSettings = settings.listRolesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getRoleSettings, this.listRolesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RoleServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RoleServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RoleServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RoleServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listRolesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetRoleRequest, Role> getRoleSettings() {
            return this.getRoleSettings;
        }

        public PagedCallSettings.Builder<ListRolesRequest, ListRolesResponse, RoleServiceClient.ListRolesPagedResponse> listRolesSettings() {
            return this.listRolesSettings;
        }

        public RoleServiceStubSettings build() throws IOException {
            return new RoleServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

