/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreateReportRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsResponse;
import com.google.ads.admanager.v1.GetReportRequest;
import com.google.ads.admanager.v1.ListReportsRequest;
import com.google.ads.admanager.v1.ListReportsResponse;
import com.google.ads.admanager.v1.Report;
import com.google.ads.admanager.v1.ReportServiceClient;
import com.google.ads.admanager.v1.RunReportMetadata;
import com.google.ads.admanager.v1.RunReportRequest;
import com.google.ads.admanager.v1.RunReportResponse;
import com.google.ads.admanager.v1.UpdateReportRequest;
import com.google.ads.admanager.v1.stub.HttpJsonReportServiceCallableFactory;
import com.google.ads.admanager.v1.stub.ReportServiceStub;
import com.google.ads.admanager.v1.stub.ReportServiceStubSettings;
import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonReportServiceStub
extends ReportServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(RunReportMetadata.getDescriptor()).add(RunReportResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetReportRequest, Report> getReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/GetReport").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/reports/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Report.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReportsRequest, ListReportsResponse> listReportsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/ListReports").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/reports", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReportsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateReportRequest, Report> createReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/CreateReport").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/reports", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("report", (Message)request.getReport(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Report.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateReportRequest, Report> updateReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/UpdateReport").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{report.name=networks/*/reports/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "report.name", (Object)request.getReport().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("report", (Message)request.getReport(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Report.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunReportRequest, Operation> runReportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/RunReport").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/reports/*}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<FetchReportResultRowsRequest, FetchReportResultRowsResponse> fetchReportResultRowsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.ReportService/FetchReportResultRows").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/reports/*/results/*}:fetchRows", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FetchReportResultRowsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetReportRequest, Report> getReportCallable;
    private final UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable;
    private final UnaryCallable<ListReportsRequest, ReportServiceClient.ListReportsPagedResponse> listReportsPagedCallable;
    private final UnaryCallable<CreateReportRequest, Report> createReportCallable;
    private final UnaryCallable<UpdateReportRequest, Report> updateReportCallable;
    private final UnaryCallable<RunReportRequest, Operation> runReportCallable;
    private final OperationCallable<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationCallable;
    private final UnaryCallable<FetchReportResultRowsRequest, FetchReportResultRowsResponse> fetchReportResultRowsCallable;
    private final UnaryCallable<FetchReportResultRowsRequest, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReportServiceStub create(ReportServiceStubSettings settings) throws IOException {
        return new HttpJsonReportServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReportServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonReportServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReportServiceStub(ReportServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReportServiceCallableFactory());
    }

    protected HttpJsonReportServiceStub(ReportServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=networks/*/operations/reports/runs/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=networks/*/operations/reports/exports/*}").build()).build()).build());
        HttpJsonCallSettings getReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listReportsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReportsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateReportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("report.name", String.valueOf(request.getReport().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings runReportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runReportMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings fetchReportResultRowsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(fetchReportResultRowsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getReportCallable = callableFactory.createUnaryCallable(getReportTransportSettings, settings.getReportSettings(), clientContext);
        this.listReportsCallable = callableFactory.createUnaryCallable(listReportsTransportSettings, settings.listReportsSettings(), clientContext);
        this.listReportsPagedCallable = callableFactory.createPagedCallable(listReportsTransportSettings, settings.listReportsSettings(), clientContext);
        this.createReportCallable = callableFactory.createUnaryCallable(createReportTransportSettings, settings.createReportSettings(), clientContext);
        this.updateReportCallable = callableFactory.createUnaryCallable(updateReportTransportSettings, settings.updateReportSettings(), clientContext);
        this.runReportCallable = callableFactory.createUnaryCallable(runReportTransportSettings, settings.runReportSettings(), clientContext);
        this.runReportOperationCallable = callableFactory.createOperationCallable(runReportTransportSettings, settings.runReportOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.fetchReportResultRowsCallable = callableFactory.createUnaryCallable(fetchReportResultRowsTransportSettings, settings.fetchReportResultRowsSettings(), clientContext);
        this.fetchReportResultRowsPagedCallable = callableFactory.createPagedCallable(fetchReportResultRowsTransportSettings, settings.fetchReportResultRowsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getReportMethodDescriptor);
        methodDescriptors.add(listReportsMethodDescriptor);
        methodDescriptors.add(createReportMethodDescriptor);
        methodDescriptors.add(updateReportMethodDescriptor);
        methodDescriptors.add(runReportMethodDescriptor);
        methodDescriptors.add(fetchReportResultRowsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetReportRequest, Report> getReportCallable() {
        return this.getReportCallable;
    }

    @Override
    public UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable() {
        return this.listReportsCallable;
    }

    @Override
    public UnaryCallable<ListReportsRequest, ReportServiceClient.ListReportsPagedResponse> listReportsPagedCallable() {
        return this.listReportsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateReportRequest, Report> createReportCallable() {
        return this.createReportCallable;
    }

    @Override
    public UnaryCallable<UpdateReportRequest, Report> updateReportCallable() {
        return this.updateReportCallable;
    }

    @Override
    public UnaryCallable<RunReportRequest, Operation> runReportCallable() {
        return this.runReportCallable;
    }

    @Override
    public OperationCallable<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationCallable() {
        return this.runReportOperationCallable;
    }

    @Override
    public UnaryCallable<FetchReportResultRowsRequest, FetchReportResultRowsResponse> fetchReportResultRowsCallable() {
        return this.fetchReportResultRowsCallable;
    }

    @Override
    public UnaryCallable<FetchReportResultRowsRequest, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsPagedCallable() {
        return this.fetchReportResultRowsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

