/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import com.google.androidbrowserhelper.playbilling.provider.Logging;
import com.google.androidbrowserhelper.playbilling.provider.MethodData;
import java.util.List;

public class PlayBillingWrapper
implements BillingWrapper {
    private final BillingWrapper.Listener mListener;
    private final BillingClient mClient;
    private final PurchasesUpdatedListener mPurchaseUpdateListener = new PurchasesUpdatedListener(){

        public void onPurchasesUpdated(BillingResult billingResult, @Nullable List<Purchase> list) {
            Logging.logPurchasesUpdate(billingResult, list);
            if (list == null || list.size() == 0) {
                PlayBillingWrapper.this.mListener.onPurchaseFlowComplete(billingResult, "");
            } else {
                PlayBillingWrapper.this.mListener.onPurchaseFlowComplete(billingResult, list.get(0).getPurchaseToken());
            }
        }
    };

    public PlayBillingWrapper(Context context, BillingWrapper.Listener listener) {
        this.mListener = listener;
        this.mClient = BillingClient.newBuilder((Context)context).setListener(this.mPurchaseUpdateListener).enablePendingPurchases().build();
    }

    @Override
    public void connect(BillingClientStateListener callback) {
        this.mClient.startConnection(callback);
    }

    @Override
    public void querySkuDetails(String skuType, List<String> skus, SkuDetailsResponseListener callback) {
        SkuDetailsParams params = SkuDetailsParams.newBuilder().setSkusList(skus).setType(skuType).build();
        this.mClient.querySkuDetailsAsync(params, callback);
    }

    @Override
    public void queryPurchases(String skuType, BillingWrapper.QueryPurchasesListener callback) {
        callback.onQueryPurchasesResponse(this.mClient.queryPurchases(skuType));
    }

    @Override
    public void acknowledge(String token, AcknowledgePurchaseResponseListener callback) {
        AcknowledgePurchaseParams params = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(token).build();
        this.mClient.acknowledgePurchase(params, callback);
    }

    @Override
    public void consume(String token, ConsumeResponseListener callback) {
        ConsumeParams params = ConsumeParams.newBuilder().setPurchaseToken(token).build();
        this.mClient.consumeAsync(params, callback);
    }

    @Override
    public boolean launchPaymentFlow(Activity activity, SkuDetails sku, MethodData methodData) {
        BillingFlowParams.Builder builder = BillingFlowParams.newBuilder();
        builder.setSkuDetails(sku);
        if (methodData.oldSku != null && methodData.purchaseToken != null) {
            builder.setOldSku(methodData.oldSku, methodData.purchaseToken);
        }
        if (methodData.prorationMode != null) {
            builder.setReplaceSkusProrationMode(methodData.prorationMode.intValue());
        }
        BillingResult result = this.mClient.launchBillingFlow(activity, builder.build());
        Logging.logLaunchPaymentFlow(result);
        return result.getResponseCode() == 0;
    }
}

