/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.trusted.Token;
import com.google.androidbrowserhelper.trusted.ChromeOsSupport;
import com.google.androidbrowserhelper.trusted.SharedPreferencesTokenStore;

public class PaymentVerifier {
    static boolean shouldAllowPayments(@NonNull Context context, @Nullable String packageName, @NonNull String logTag) {
        if (packageName == null) {
            return false;
        }
        if (ChromeOsSupport.isRunningOnArc((PackageManager)context.getPackageManager()) && packageName.equals("org.chromium.arc.payment_app")) {
            return true;
        }
        SharedPreferencesTokenStore tokenStore = new SharedPreferencesTokenStore(context);
        Token verifiedPackage = tokenStore.load();
        if (verifiedPackage == null) {
            Log.w((String)logTag, (String)"Denied payment as no verified app set.");
            return false;
        }
        boolean verified = verifiedPackage.matches(packageName, context.getPackageManager());
        if (!verified) {
            Log.w((String)logTag, (String)("Denied payment to unverified app (" + packageName + ")."));
        }
        return verified;
    }
}

