/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class MethodData {
    public final String sku;
    @Nullable
    public final String oldSku;
    @Nullable
    public final String purchaseToken;
    @Nullable
    public final Integer prorationMode;

    private MethodData(String sku, @Nullable String oldSku, @Nullable String purchaseToken, @Nullable Integer prorationMode) {
        this.sku = sku;
        this.oldSku = oldSku;
        this.purchaseToken = purchaseToken;
        this.prorationMode = prorationMode;
    }

    @Nullable
    public static MethodData fromJson(String json) {
        try {
            return MethodData.fromJsonInner(json);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    private static MethodData fromJsonInner(String json) throws JSONException {
        JSONObject dataObject = new JSONObject(json);
        String sku = dataObject.optString("sku");
        if (TextUtils.isEmpty((CharSequence)sku)) {
            return null;
        }
        String oldSku = MethodData.getString(dataObject, "oldSku");
        String purchaseToken = MethodData.getString(dataObject, "purchaseToken");
        Integer prorationMode = MethodData.getProration(dataObject);
        return new MethodData(sku, oldSku, purchaseToken, prorationMode);
    }

    @Nullable
    public static MethodData fromIntent(Intent intent) {
        ArrayList methods = intent.getStringArrayListExtra("methodNames");
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        String method = (String)methods.get(0);
        Bundle methodDatas = intent.getBundleExtra("methodData");
        if (methodDatas == null) {
            return null;
        }
        String methodDataJson = methodDatas.getString(method);
        if (TextUtils.isEmpty((CharSequence)methodDataJson)) {
            return null;
        }
        return MethodData.fromJson(methodDataJson);
    }

    @Nullable
    private static String getString(JSONObject object, String key) {
        String value = object.optString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return value;
    }

    @Nullable
    private static Integer getProration(JSONObject object) {
        String proration = MethodData.getString(object, "prorationMode");
        if (proration == null) {
            return null;
        }
        switch (proration) {
            case "deferred": {
                return 4;
            }
            case "immediateAndChargeProratedPrice": {
                return 2;
            }
            case "immediateWithoutProration": {
                return 3;
            }
            case "immediateWithTimeProration": {
                return 1;
            }
            case "unknownSubscriptionUpgradeDowngradePolicy": {
                return 0;
            }
        }
        return null;
    }
}

