/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.util.Log;
import com.android.billingclient.api.BillingResult;
import java.util.List;

public class Logging {
    private static final String TAG = "TwaBilling.DG";

    static void logUnknownCommand(String commandName) {
        Log.d((String)TAG, (String)("Got unknown command: " + commandName));
    }

    static void logAckCall(String token, boolean makeAvailableAgain) {
        if (makeAvailableAgain) {
            Log.d((String)TAG, (String)("Calling acknowledge " + token));
        } else {
            Log.d((String)TAG, (String)("Calling consume " + token));
        }
    }

    static void logAckResponse(BillingResult result, boolean makeAvailableAgain) {
        String command = makeAvailableAgain ? "Acknowledge" : "Consume";
        Logging.logResult(result, command + " returned:");
    }

    static void logGetDetailsCall(List<String> ids) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(id);
            first = false;
        }
        Log.d((String)TAG, (String)("Calling getDetails for " + sb.toString()));
    }

    static void logGetDetailsResponse(BillingResult result) {
        Logging.logResult(result, "GetDetails returned:");
    }

    static void logListPurchasesCall() {
        Log.d((String)TAG, (String)"Calling listPurchases");
    }

    static void logListPurchasesResult(BillingResult result) {
        Logging.logResult(result, "ListPurchases returned:");
    }

    private static void logResult(BillingResult result, String message) {
        int responseCode = result.getResponseCode();
        Log.d((String)TAG, (String)(message + " " + responseCode));
        String debugMessage = result.getDebugMessage();
        if (debugMessage != null && !debugMessage.isEmpty()) {
            Log.d((String)TAG, (String)debugMessage);
        }
    }

    static void logConnected() {
        Log.d((String)TAG, (String)"Connected to Play Billing library.");
    }

    static void logDisconnected() {
        Log.d((String)TAG, (String)"Disconnected from Play Billing library.");
    }

    static void logUnknownResultCode(int resultCode) {
        Log.w((String)TAG, (String)("Cannot convert result code: " + resultCode));
    }
}

