/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zzb;

public final class WalletFragmentOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzb();
    final int mVersionCode;
    private int aQL;
    private int mTheme;
    private WalletFragmentStyle aRA;
    private int IT;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        ((Object)((Object)walletFragmentOptions)).getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.mVersionCode = 1;
        this.aQL = 3;
        this.aRA = new WalletFragmentStyle();
    }

    WalletFragmentOptions(int n, int n2, int n3, WalletFragmentStyle walletFragmentStyle, int n4) {
        this.mVersionCode = n;
        this.aQL = n2;
        this.mTheme = n3;
        this.aRA = walletFragmentStyle;
        this.IT = n4;
    }

    public int getEnvironment() {
        return this.aQL;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.aRA;
    }

    public int getMode() {
        return this.IT;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public void zzek(Context context) {
        if (this.aRA != null) {
            this.aRA.zzek(context);
        }
    }

    public static WalletFragmentOptions zzc(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n;
        walletFragmentOptions.aQL = n2;
        walletFragmentOptions.aRA = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.aRA.zzek(context);
        walletFragmentOptions.IT = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int n) {
            WalletFragmentOptions.this.aQL = n;
            return this;
        }

        public Builder setTheme(int n) {
            WalletFragmentOptions.this.mTheme = n;
            return this;
        }

        public Builder setFragmentStyle(int n) {
            WalletFragmentOptions.this.aRA = new WalletFragmentStyle().setStyleResourceId(n);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle walletFragmentStyle) {
            WalletFragmentOptions.this.aRA = walletFragmentStyle;
            return this;
        }

        public Builder setMode(int n) {
            WalletFragmentOptions.this.IT = n;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

