/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzagc;
import com.google.android.gms.internal.zzagd;
import com.google.android.gms.internal.zzagk;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb aRe;
    private boolean mCreated = false;
    private final zzh aRf = zzh.zza((Fragment)this);
    private final zzc aRg = new zzc();
    private zza aRh = new zza(this);
    private final Fragment Qg = this;
    private WalletFragmentOptions aRi;
    private WalletFragmentInitParams aRj;
    private MaskedWalletRequest aRk;
    private MaskedWallet aRl;
    private Boolean aRm;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.Qg.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.aRe != null) {
            this.aRe.initialize(walletFragmentInitParams);
            this.aRj = null;
        } else if (this.aRj == null) {
            this.aRj = walletFragmentInitParams;
            if (this.aRk != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.aRl != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.aRe != null) {
            this.aRe.updateMaskedWalletRequest(maskedWalletRequest);
            this.aRk = null;
        } else {
            this.aRk = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.aRe != null) {
            this.aRe.updateMaskedWallet(maskedWallet);
            this.aRl = null;
        } else {
            this.aRl = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.aRe != null) {
            this.aRe.setEnabled(bl);
            this.aRm = null;
        } else {
            this.aRm = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.aRh.zza(onStateChangedListener);
    }

    public int getState() {
        return this.aRe != null ? this.aRe.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.aRi == null) {
            this.aRi = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.aRi);
        this.aRg.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aRj != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aRj = walletFragmentInitParams;
            }
            if (this.aRk == null) {
                this.aRk = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.aRl == null) {
                this.aRl = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.aRi = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.aRm = bundle.getBoolean("enabled");
            }
        } else if (this.Qg.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Qg.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzek((Context)this.Qg.getActivity());
            this.aRi = walletFragmentOptions;
        }
        this.mCreated = true;
        this.aRg.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.aRg.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.aRg.onStart();
    }

    public void onResume() {
        super.onResume();
        this.aRg.onResume();
        FragmentManager fragmentManager = this.Qg.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Qg.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.Qg.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.aRg.onPause();
    }

    public void onStop() {
        super.onStop();
        this.aRg.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.aRg.onSaveInstanceState(bundle);
        if (this.aRj != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.aRj);
            this.aRj = null;
        }
        if (this.aRk != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.aRk);
            this.aRk = null;
        }
        if (this.aRl != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.aRl);
            this.aRl = null;
        }
        if (this.aRi != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.aRi);
            this.aRi = null;
        }
        if (this.aRm != null) {
            bundle.putBoolean("enabled", this.aRm.booleanValue());
            this.aRm = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.aRe != null) {
            this.aRe.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzagd.zza {
        private OnStateChangedListener aRn;
        private final SupportWalletFragment aRo;

        zza(SupportWalletFragment supportWalletFragment) {
            this.aRo = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.aRn != null) {
                this.aRn.onStateChanged(this.aRo, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.aRn = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzagc aRp;

        private zzb(zzagc zzagc2) {
            this.aRp = zzagc2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.aRp.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.aRp.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.aRp.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.aRp.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.aRp.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.aRp.zza(zze.zzac((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.aRp.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.aRp.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
                return (View)zze.zzae((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.aRp.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aRp.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aRp.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aRp.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aRp.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.aRp.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Qg.getActivity();
            if (SupportWalletFragment.this.aRe == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzagc zzagc2 = zzagk.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.aRf, SupportWalletFragment.this.aRi, SupportWalletFragment.this.aRh);
                    SupportWalletFragment.this.aRe = new zzb(zzagc2);
                    SupportWalletFragment.this.aRi = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.aRe);
                if (SupportWalletFragment.this.aRj != null) {
                    SupportWalletFragment.this.aRe.initialize(SupportWalletFragment.this.aRj);
                    SupportWalletFragment.this.aRj = null;
                }
                if (SupportWalletFragment.this.aRk != null) {
                    SupportWalletFragment.this.aRe.updateMaskedWalletRequest(SupportWalletFragment.this.aRk);
                    SupportWalletFragment.this.aRk = null;
                }
                if (SupportWalletFragment.this.aRl != null) {
                    SupportWalletFragment.this.aRe.updateMaskedWallet(SupportWalletFragment.this.aRl);
                    SupportWalletFragment.this.aRl = null;
                }
                if (SupportWalletFragment.this.aRm != null) {
                    SupportWalletFragment.this.aRe.setEnabled(SupportWalletFragment.this.aRm);
                    SupportWalletFragment.this.aRm = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.Qg.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.aRi != null && (walletFragmentStyle = SupportWalletFragment.this.aRi.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.Qg.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Qg.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

