/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.zzm;
import java.util.ArrayList;
import java.util.Collection;

public final class MaskedWalletRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzm();
    private final int mVersionCode;
    String aPn;
    boolean aQk;
    boolean aQl;
    boolean aQm;
    String aQn;
    String aPg;
    String aQo;
    Cart aPx;
    boolean aQp;
    boolean aQq;
    CountrySpecification[] aQr;
    boolean aQs;
    boolean aQt;
    ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> aQu;
    PaymentMethodTokenizationParameters aQv;
    ArrayList<Integer> aQw;
    String zzcpw;

    public static Builder newBuilder() {
        MaskedWalletRequest maskedWalletRequest = new MaskedWalletRequest();
        ((Object)((Object)maskedWalletRequest)).getClass();
        return maskedWalletRequest.new Builder();
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    MaskedWalletRequest(int n, String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, Cart cart, boolean bl4, boolean bl5, CountrySpecification[] countrySpecificationArray, boolean bl6, boolean bl7, ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, ArrayList<Integer> arrayList2, String string5) {
        this.mVersionCode = n;
        this.aPn = string;
        this.aQk = bl;
        this.aQl = bl2;
        this.aQm = bl3;
        this.aQn = string2;
        this.aPg = string3;
        this.aQo = string4;
        this.aPx = cart;
        this.aQp = bl4;
        this.aQq = bl5;
        this.aQr = countrySpecificationArray;
        this.aQs = bl6;
        this.aQt = bl7;
        this.aQu = arrayList;
        this.aQv = paymentMethodTokenizationParameters;
        this.aQw = arrayList2;
        this.zzcpw = string5;
    }

    MaskedWalletRequest() {
        this.mVersionCode = 3;
        this.aQs = true;
        this.aQt = true;
    }

    public String getMerchantTransactionId() {
        return this.aPn;
    }

    public boolean isPhoneNumberRequired() {
        return this.aQk;
    }

    public boolean isShippingAddressRequired() {
        return this.aQl;
    }

    @Deprecated
    public boolean useMinimalBillingAddress() {
        return this.aQm;
    }

    public String getEstimatedTotalPrice() {
        return this.aQn;
    }

    public String getCurrencyCode() {
        return this.aPg;
    }

    public String getMerchantName() {
        return this.aQo;
    }

    public Cart getCart() {
        return this.aPx;
    }

    @Deprecated
    public boolean isBillingAgreement() {
        return this.aQq;
    }

    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.aQr;
    }

    public boolean allowPrepaidCard() {
        return this.aQs;
    }

    public boolean allowDebitCard() {
        return this.aQt;
    }

    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.aQu;
    }

    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.aQv;
    }

    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.aQw;
    }

    public String getCountryCode() {
        return this.zzcpw;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setMerchantTransactionId(String string) {
            MaskedWalletRequest.this.aPn = string;
            return this;
        }

        public Builder setPhoneNumberRequired(boolean bl) {
            MaskedWalletRequest.this.aQk = bl;
            return this;
        }

        public Builder setShippingAddressRequired(boolean bl) {
            MaskedWalletRequest.this.aQl = bl;
            return this;
        }

        @Deprecated
        public Builder setUseMinimalBillingAddress(boolean bl) {
            MaskedWalletRequest.this.aQm = bl;
            return this;
        }

        public Builder setEstimatedTotalPrice(String string) {
            MaskedWalletRequest.this.aQn = string;
            return this;
        }

        public Builder setCurrencyCode(String string) {
            MaskedWalletRequest.this.aPg = string;
            return this;
        }

        public Builder setMerchantName(String string) {
            MaskedWalletRequest.this.aQo = string;
            return this;
        }

        public Builder setCart(Cart cart) {
            MaskedWalletRequest.this.aPx = cart;
            return this;
        }

        @Deprecated
        public Builder setIsBillingAgreement(boolean bl) {
            MaskedWalletRequest.this.aQq = bl;
            return this;
        }

        public Builder setAllowPrepaidCard(boolean bl) {
            MaskedWalletRequest.this.aQs = bl;
            return this;
        }

        public Builder setAllowDebitCard(boolean bl) {
            MaskedWalletRequest.this.aQt = bl;
            return this;
        }

        public Builder addAllowedCountrySpecificationForShipping(com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            if (MaskedWalletRequest.this.aQu == null) {
                MaskedWalletRequest.this.aQu = new ArrayList();
            }
            MaskedWalletRequest.this.aQu.add(countrySpecification);
            return this;
        }

        public Builder addAllowedCountrySpecificationsForShipping(Collection<com.google.android.gms.identity.intents.model.CountrySpecification> collection) {
            if (collection != null) {
                if (MaskedWalletRequest.this.aQu == null) {
                    MaskedWalletRequest.this.aQu = new ArrayList();
                }
                MaskedWalletRequest.this.aQu.addAll(collection);
            }
            return this;
        }

        public Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            MaskedWalletRequest.this.aQv = paymentMethodTokenizationParameters;
            return this;
        }

        public Builder addAllowedCardNetwork(int n) {
            if (MaskedWalletRequest.this.aQw == null) {
                MaskedWalletRequest.this.aQw = new ArrayList();
            }
            MaskedWalletRequest.this.aQw.add(n);
            return this;
        }

        public Builder addAllowedCardNetworks(Collection<Integer> collection) {
            if (collection != null) {
                if (MaskedWalletRequest.this.aQw == null) {
                    MaskedWalletRequest.this.aQw = new ArrayList();
                }
                MaskedWalletRequest.this.aQw.addAll(collection);
            }
            return this;
        }

        public Builder setCountryCode(String string) {
            MaskedWalletRequest.this.zzcpw = string;
            return this;
        }

        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }
    }
}

