/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zzb;

public final class WalletFragmentOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzb();
    final int mVersionCode;
    private int aNA;
    private int mTheme;
    private WalletFragmentStyle aOo;
    private int Hh;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        ((Object)((Object)walletFragmentOptions)).getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.mVersionCode = 1;
        this.aNA = 3;
        this.aOo = new WalletFragmentStyle();
    }

    WalletFragmentOptions(int n, int n2, int n3, WalletFragmentStyle walletFragmentStyle, int n4) {
        this.mVersionCode = n;
        this.aNA = n2;
        this.mTheme = n3;
        this.aOo = walletFragmentStyle;
        this.Hh = n4;
    }

    public int getEnvironment() {
        return this.aNA;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.aOo;
    }

    public int getMode() {
        return this.Hh;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public void zzen(Context context) {
        if (this.aOo != null) {
            this.aOo.zzen(context);
        }
    }

    public static WalletFragmentOptions zzc(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n;
        walletFragmentOptions.aNA = n2;
        walletFragmentOptions.aOo = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.aOo.zzen(context);
        walletFragmentOptions.Hh = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int n) {
            WalletFragmentOptions.this.aNA = n;
            return this;
        }

        public Builder setTheme(int n) {
            WalletFragmentOptions.this.mTheme = n;
            return this;
        }

        public Builder setFragmentStyle(int n) {
            WalletFragmentOptions.this.aOo = new WalletFragmentStyle().setStyleResourceId(n);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle walletFragmentStyle) {
            WalletFragmentOptions.this.aOo = walletFragmentStyle;
            return this;
        }

        public Builder setMode(int n) {
            WalletFragmentOptions.this.Hh = n;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

