/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.fragment.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class WalletFragmentStyle
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WalletFragmentStyle> CREATOR = new zzc();
    final int mVersionCode;
    Bundle zzbAZ;
    int zzbBa;

    public WalletFragmentStyle() {
        this.mVersionCode = 1;
        this.zzbAZ = new Bundle();
        this.zzbAZ.putInt("buyButtonAppearanceDefault", 4);
        this.zzbAZ.putInt("maskedWalletDetailsLogoImageTypeDefault", 3);
    }

    WalletFragmentStyle(int n, Bundle bundle, int n2) {
        this.mVersionCode = n;
        this.zzbAZ = bundle;
        this.zzbBa = n2;
    }

    public WalletFragmentStyle setStyleResourceId(int n) {
        this.zzbBa = n;
        return this;
    }

    public WalletFragmentStyle setBuyButtonText(int n) {
        this.zzbAZ.putInt("buyButtonText", n);
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int n) {
        this.zzbAZ.putLong("buyButtonHeight", WalletFragmentStyle.zzmg(n));
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int n, float f) {
        this.zzbAZ.putLong("buyButtonHeight", WalletFragmentStyle.zza(n, f));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int n) {
        this.zzbAZ.putLong("buyButtonWidth", WalletFragmentStyle.zzmg(n));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int n, float f) {
        this.zzbAZ.putLong("buyButtonWidth", WalletFragmentStyle.zza(n, f));
        return this;
    }

    public WalletFragmentStyle setBuyButtonAppearance(int n) {
        this.zzbAZ.putInt("buyButtonAppearance", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsTextAppearance(int n) {
        this.zzbAZ.putInt("maskedWalletDetailsTextAppearance", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsHeaderTextAppearance(int n) {
        this.zzbAZ.putInt("maskedWalletDetailsHeaderTextAppearance", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundColor(int n) {
        this.zzbAZ.remove("maskedWalletDetailsBackgroundResource");
        this.zzbAZ.putInt("maskedWalletDetailsBackgroundColor", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundResource(int n) {
        this.zzbAZ.remove("maskedWalletDetailsBackgroundColor");
        this.zzbAZ.putInt("maskedWalletDetailsBackgroundResource", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonTextAppearance(int n) {
        this.zzbAZ.putInt("maskedWalletDetailsButtonTextAppearance", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundColor(int n) {
        this.zzbAZ.remove("maskedWalletDetailsButtonBackgroundResource");
        this.zzbAZ.putInt("maskedWalletDetailsButtonBackgroundColor", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundResource(int n) {
        this.zzbAZ.remove("maskedWalletDetailsButtonBackgroundColor");
        this.zzbAZ.putInt("maskedWalletDetailsButtonBackgroundResource", n);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsLogoImageType(int n) {
        this.zzbAZ.putInt("maskedWalletDetailsLogoImageType", n);
        return this;
    }

    @Deprecated
    public WalletFragmentStyle setMaskedWalletDetailsLogoTextColor(int n) {
        this.zzbAZ.putInt("maskedWalletDetailsLogoTextColor", n);
        return this;
    }

    public int zza(String string2, DisplayMetrics displayMetrics, int n) {
        if (this.zzbAZ.containsKey(string2)) {
            return WalletFragmentStyle.zza(this.zzbAZ.getLong(string2), displayMetrics);
        }
        return n;
    }

    private static int zza(long l, DisplayMetrics displayMetrics) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = -1;
        switch (n) {
            case 129: {
                return n2;
            }
            case 128: {
                return TypedValue.complexToDimensionPixelSize((int)n2, (DisplayMetrics)displayMetrics);
            }
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 4;
                break;
            }
            case 5: {
                n3 = 5;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(36).append("Unexpected unit or type: ").append(n).toString());
            }
        }
        return Math.round(TypedValue.applyDimension((int)n3, (float)Float.intBitsToFloat(n2), (DisplayMetrics)displayMetrics));
    }

    private static long zza(int n, float f) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return WalletFragmentStyle.zzw(n, Float.floatToIntBits(f));
            }
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unrecognized unit: ").append(n).toString());
    }

    private static long zzmg(int n) {
        if (n < 0) {
            if (n == -1 || n == -2) {
                return WalletFragmentStyle.zzw(129, n);
            }
            throw new IllegalArgumentException(new StringBuilder(39).append("Unexpected dimension value: ").append(n).toString());
        }
        return WalletFragmentStyle.zza(0, n);
    }

    private static long zza(TypedValue typedValue) {
        switch (typedValue.type) {
            case 16: {
                return WalletFragmentStyle.zzmg(typedValue.data);
            }
            case 5: {
                return WalletFragmentStyle.zzw(128, typedValue.data);
            }
        }
        int n = typedValue.type;
        throw new IllegalArgumentException(new StringBuilder(38).append("Unexpected dimension type: ").append(n).toString());
    }

    private static long zzw(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public void zzbt(Context context) {
        int n = this.zzbBa <= 0 ? R.style.WalletFragmentDefaultStyle : this.zzbBa;
        int[] nArray = R.styleable.WalletFragmentStyle;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonWidth, "buyButtonWidth");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonHeight, "buyButtonHeight");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonText, "buyButtonText");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonAppearance, "buyButtonAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsTextAppearance, "maskedWalletDetailsTextAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsHeaderTextAppearance, "maskedWalletDetailsHeaderTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsBackground, "maskedWalletDetailsBackgroundColor", "maskedWalletDetailsBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonTextAppearance, "maskedWalletDetailsButtonTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonBackground, "maskedWalletDetailsButtonBackgroundColor", "maskedWalletDetailsButtonBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoTextColor, "maskedWalletDetailsLogoTextColor");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoImageType, "maskedWalletDetailsLogoImageType");
        typedArray.recycle();
    }

    private void zza(TypedArray typedArray, int n, String string2) {
        if (this.zzbAZ.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzbAZ.putLong(string2, WalletFragmentStyle.zza(typedValue));
        }
    }

    private void zzb(TypedArray typedArray, int n, String string2) {
        if (this.zzbAZ.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzbAZ.putInt(string2, typedValue.data);
        }
    }

    private void zza(TypedArray typedArray, int n, String string2, String string3) {
        if (this.zzbAZ.containsKey(string2) || this.zzbAZ.containsKey(string3)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                this.zzbAZ.putInt(string2, typedValue.data);
            } else {
                this.zzbAZ.putInt(string3, typedValue.resourceId);
            }
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Dimension {
        public static final int UNIT_PX = 0;
        public static final int UNIT_DIP = 1;
        public static final int UNIT_SP = 2;
        public static final int UNIT_PT = 3;
        public static final int UNIT_IN = 4;
        public static final int UNIT_MM = 5;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogoImageType {
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 2;
        public static final int ANDROID_PAY = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonAppearance {
        public static final int ANDROID_PAY_DARK = 4;
        public static final int ANDROID_PAY_LIGHT = 5;
        public static final int ANDROID_PAY_LIGHT_WITH_BORDER = 6;
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_GRAYSCALE = 2;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonText {
        public static final int BUY_WITH = 5;
        public static final int LOGO_ONLY = 6;
        public static final int DONATE_WITH = 7;
    }
}

