/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzace;
import com.google.android.gms.internal.zzacf;
import com.google.android.gms.internal.zzach;
import com.google.android.gms.internal.zzaci;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzj;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzacf> zzaaz = new Api.zzf();
    private static final Api.zza<zzacf, WalletOptions> zzaaA = new Api.zza<zzacf, WalletOptions>(){

        public zzacf zza(Context context, Looper looper, zzg zzg2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new zzacf(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, walletOptions2.theme, walletOptions2.zzbAq);
        }
    };
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzaaA, zzaaz);
    public static final Payments Payments = new zzace();
    public static final zzj zzbAo = new zzaci();
    public static final com.google.android.gms.wallet.firstparty.zza zzbAp = new zzach();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int n) {
        Payments.checkForPreAuthorization(googleApiClient, n);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest maskedWalletRequest, int n) {
        Payments.loadMaskedWallet(googleApiClient, maskedWalletRequest, n);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest fullWalletRequest, int n) {
        Payments.loadFullWallet(googleApiClient, fullWalletRequest, n);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String string, String string2, int n) {
        Payments.changeMaskedWallet(googleApiClient, string, string2, n);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Payments.notifyTransactionStatus(googleApiClient, notifyTransactionStatusRequest);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class zza<R extends Result>
    extends zznt.zza<R, zzacf> {
        public zza(GoogleApiClient googleApiClient) {
            super((Api.zzc)zzaaz, googleApiClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;
        private final boolean zzbAq;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzbAr;
            this.theme = builder.mTheme;
            this.zzbAq = builder.zzbAs;
        }

        public static final class Builder {
            private int zzbAr = 3;
            private int mTheme = 0;
            private boolean zzbAs = true;

            public Builder setEnvironment(int n) {
                if (n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzbAr = n;
                return this;
            }

            public Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public Builder useGoogleWallet() {
                this.zzbAs = false;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

