/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.fragment.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class WalletFragmentStyle
implements SafeParcelable {
    public static final Parcelable.Creator<WalletFragmentStyle> CREATOR = new zzc();
    final int mVersionCode;
    Bundle zzbqu;
    int zzbqv;

    public WalletFragmentStyle() {
        this.mVersionCode = 1;
        this.zzbqu = new Bundle();
        this.zzbqu.putInt("buyButtonAppearanceDefault", 4);
        this.zzbqu.putInt("maskedWalletDetailsLogoImageTypeDefault", 3);
    }

    WalletFragmentStyle(int versionCode, Bundle attributes, int styleResourceId) {
        this.mVersionCode = versionCode;
        this.zzbqu = attributes;
        this.zzbqv = styleResourceId;
    }

    public WalletFragmentStyle setStyleResourceId(int id) {
        this.zzbqv = id;
        return this;
    }

    public WalletFragmentStyle setBuyButtonText(int buyButtonText) {
        this.zzbqu.putInt("buyButtonText", buyButtonText);
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int height) {
        this.zzbqu.putLong("buyButtonHeight", WalletFragmentStyle.zzll(height));
        return this;
    }

    public WalletFragmentStyle setBuyButtonHeight(int unit, float height) {
        this.zzbqu.putLong("buyButtonHeight", WalletFragmentStyle.zza(unit, height));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int width) {
        this.zzbqu.putLong("buyButtonWidth", WalletFragmentStyle.zzll(width));
        return this;
    }

    public WalletFragmentStyle setBuyButtonWidth(int unit, float width) {
        this.zzbqu.putLong("buyButtonWidth", WalletFragmentStyle.zza(unit, width));
        return this;
    }

    public WalletFragmentStyle setBuyButtonAppearance(int buyButtonAppearance) {
        this.zzbqu.putInt("buyButtonAppearance", buyButtonAppearance);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsTextAppearance(int resourceId) {
        this.zzbqu.putInt("maskedWalletDetailsTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsHeaderTextAppearance(int resourceId) {
        this.zzbqu.putInt("maskedWalletDetailsHeaderTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundColor(int color) {
        this.zzbqu.remove("maskedWalletDetailsBackgroundResource");
        this.zzbqu.putInt("maskedWalletDetailsBackgroundColor", color);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsBackgroundResource(int resourceId) {
        this.zzbqu.remove("maskedWalletDetailsBackgroundColor");
        this.zzbqu.putInt("maskedWalletDetailsBackgroundResource", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonTextAppearance(int resourceId) {
        this.zzbqu.putInt("maskedWalletDetailsButtonTextAppearance", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundColor(int color) {
        this.zzbqu.remove("maskedWalletDetailsButtonBackgroundResource");
        this.zzbqu.putInt("maskedWalletDetailsButtonBackgroundColor", color);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundResource(int resourceId) {
        this.zzbqu.remove("maskedWalletDetailsButtonBackgroundColor");
        this.zzbqu.putInt("maskedWalletDetailsButtonBackgroundResource", resourceId);
        return this;
    }

    public WalletFragmentStyle setMaskedWalletDetailsLogoImageType(int imageType) {
        this.zzbqu.putInt("maskedWalletDetailsLogoImageType", imageType);
        return this;
    }

    @Deprecated
    public WalletFragmentStyle setMaskedWalletDetailsLogoTextColor(int color) {
        this.zzbqu.putInt("maskedWalletDetailsLogoTextColor", color);
        return this;
    }

    public int zza(String string2, DisplayMetrics displayMetrics, int n) {
        if (this.zzbqu.containsKey(string2)) {
            return WalletFragmentStyle.zza(this.zzbqu.getLong(string2), displayMetrics);
        }
        return n;
    }

    private static int zza(long l, DisplayMetrics displayMetrics) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = -1;
        switch (n) {
            case 129: {
                return n2;
            }
            case 128: {
                return TypedValue.complexToDimensionPixelSize((int)n2, (DisplayMetrics)displayMetrics);
            }
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 4;
                break;
            }
            case 5: {
                n3 = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected unit or type: " + n);
            }
        }
        return Math.round(TypedValue.applyDimension((int)n3, (float)Float.intBitsToFloat(n2), (DisplayMetrics)displayMetrics));
    }

    private static long zza(int n, float f) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return WalletFragmentStyle.zzv(n, Float.floatToIntBits(f));
            }
        }
        throw new IllegalArgumentException("Unrecognized unit: " + n);
    }

    private static long zzll(int n) {
        if (n < 0) {
            if (n == -1 || n == -2) {
                return WalletFragmentStyle.zzv(129, n);
            }
            throw new IllegalArgumentException("Unexpected dimension value: " + n);
        }
        return WalletFragmentStyle.zza(0, n);
    }

    private static long zza(TypedValue typedValue) {
        switch (typedValue.type) {
            case 16: {
                return WalletFragmentStyle.zzll(typedValue.data);
            }
            case 5: {
                return WalletFragmentStyle.zzv(128, typedValue.data);
            }
        }
        throw new IllegalArgumentException("Unexpected dimension type: " + typedValue.type);
    }

    private static long zzv(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public void zzbc(Context context) {
        int n = this.zzbqv <= 0 ? R.style.WalletFragmentDefaultStyle : this.zzbqv;
        int[] nArray = R.styleable.WalletFragmentStyle;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonWidth, "buyButtonWidth");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonHeight, "buyButtonHeight");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonText, "buyButtonText");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonAppearance, "buyButtonAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsTextAppearance, "maskedWalletDetailsTextAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsHeaderTextAppearance, "maskedWalletDetailsHeaderTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsBackground, "maskedWalletDetailsBackgroundColor", "maskedWalletDetailsBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonTextAppearance, "maskedWalletDetailsButtonTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonBackground, "maskedWalletDetailsButtonBackgroundColor", "maskedWalletDetailsButtonBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoTextColor, "maskedWalletDetailsLogoTextColor");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoImageType, "maskedWalletDetailsLogoImageType");
        typedArray.recycle();
    }

    private void zza(TypedArray typedArray, int n, String string2) {
        if (this.zzbqu.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzbqu.putLong(string2, WalletFragmentStyle.zza(typedValue));
        }
    }

    private void zzb(TypedArray typedArray, int n, String string2) {
        if (this.zzbqu.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzbqu.putInt(string2, typedValue.data);
        }
    }

    private void zza(TypedArray typedArray, int n, String string2, String string3) {
        if (this.zzbqu.containsKey(string2) || this.zzbqu.containsKey(string3)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                this.zzbqu.putInt(string2, typedValue.data);
            } else {
                this.zzbqu.putInt(string3, typedValue.resourceId);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Dimension {
        public static final int UNIT_PX = 0;
        public static final int UNIT_DIP = 1;
        public static final int UNIT_SP = 2;
        public static final int UNIT_PT = 3;
        public static final int UNIT_IN = 4;
        public static final int UNIT_MM = 5;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogoImageType {
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 2;
        public static final int ANDROID_PAY = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonAppearance {
        public static final int ANDROID_PAY_DARK = 4;
        public static final int ANDROID_PAY_LIGHT = 5;
        public static final int ANDROID_PAY_LIGHT_WITH_BORDER = 6;
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_GRAYSCALE = 2;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonText {
        public static final int BUY_WITH = 5;
        public static final int LOGO_ONLY = 6;
        public static final int DONATE_WITH = 7;
    }
}

