/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.firstparty.GetBuyFlowInitializationTokenResponse;
import com.google.android.gms.wallet.firstparty.GetInstrumentsResponse;
import java.lang.ref.WeakReference;

public class zzrh
extends zzj<zzrc> {
    private final Context mContext;
    private final int zzaXE;
    private final String zzQE;
    private final int mTheme;

    public zzrh(Context context, Looper looper, zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2) {
        super(context, looper, 4, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.mContext = context;
        this.zzaXE = n;
        this.zzQE = zzf2.getAccountName();
        this.mTheme = n2;
    }

    public boolean zzoC() {
        return true;
    }

    protected String zzfA() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected String zzfB() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    protected zzrc zzdV(IBinder iBinder) {
        return zzrc.zza.zzdR(iBinder);
    }

    public void zzki(int n) {
        Bundle bundle = this.zzCl();
        zzb zzb2 = new zzb(this.mContext, n);
        try {
            ((zzrc)this.zzoA()).zza(bundle, zzb2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            zzb2.zza(8, false, Bundle.EMPTY);
        }
    }

    public void zze(String string, String string2, int n) {
        Bundle bundle = this.zzCl();
        zzb zzb2 = new zzb(this.mContext, n);
        try {
            ((zzrc)this.zzoA()).zza(string, string2, bundle, zzb2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            zzb2.zza(8, (MaskedWallet)null, Bundle.EMPTY);
        }
    }

    public void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        Bundle bundle = this.zzCl();
        zzb zzb2 = new zzb(this.mContext, n);
        try {
            ((zzrc)this.zzoA()).zza(maskedWalletRequest, bundle, (zzrf)zzb2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            zzb2.zza(8, (MaskedWallet)null, Bundle.EMPTY);
        }
    }

    public void zza(FullWalletRequest fullWalletRequest, int n) {
        zzb zzb2 = new zzb(this.mContext, n);
        Bundle bundle = this.zzCl();
        try {
            ((zzrc)this.zzoA()).zza(fullWalletRequest, bundle, (zzrf)zzb2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            zzb2.zza(8, (FullWallet)null, Bundle.EMPTY);
        }
    }

    public void zza(NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Bundle bundle = this.zzCl();
        try {
            ((zzrc)this.zzoA()).zza(notifyTransactionStatusRequest, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void zzkj(int n) {
        Bundle bundle = this.zzCl();
        zzb zzb2 = new zzb(this.mContext, n);
        try {
            ((zzrc)this.zzoA()).zzb(bundle, zzb2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isNewUser", (Throwable)remoteException);
            zzb2.zzb(8, false, Bundle.EMPTY);
        }
    }

    public static Bundle zza(int n, String string, String string2, int n2) {
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n);
        bundle.putString("androidPackageName", string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string2, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n2);
        return bundle;
    }

    private Bundle zzCl() {
        return zzrh.zza(this.zzaXE, this.mContext.getPackageName(), this.zzQE, this.mTheme);
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzdV(iBinder);
    }

    static final class zzb
    extends zza {
        private final WeakReference<Activity> zzaYs;
        private final int zzadi;

        public zzb(Context context, int n) {
            this.zzaYs = new WeakReference<Activity>((Activity)context);
            this.zzadi = n;
        }

        @Override
        public void zza(int n, MaskedWallet maskedWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            Activity activity = (Activity)this.zzaYs.get();
            if (activity == null) {
                Log.d((String)"WalletClientImpl", (String)"Ignoring onMaskedWalletLoaded, Activity has gone");
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(activity, this.zzadi);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                int n2;
                Intent intent = new Intent();
                if (connectionResult.isSuccess()) {
                    n2 = -1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET", (Parcelable)maskedWallet);
                } else {
                    n2 = n == 408 ? 0 : 1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
                }
                PendingIntent pendingIntent2 = activity.createPendingResult(this.zzadi, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onMaskedWalletLoaded");
                    return;
                }
                try {
                    pendingIntent2.send(n2);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        @Override
        public void zza(int n, FullWallet fullWallet, Bundle bundle) {
            ConnectionResult connectionResult;
            Activity activity = (Activity)this.zzaYs.get();
            if (activity == null) {
                Log.d((String)"WalletClientImpl", (String)"Ignoring onFullWalletLoaded, Activity has gone");
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(activity, this.zzadi);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                int n2;
                Intent intent = new Intent();
                if (connectionResult.isSuccess()) {
                    n2 = -1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET", (Parcelable)fullWallet);
                } else {
                    n2 = n == 408 ? 0 : 1;
                    intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
                }
                PendingIntent pendingIntent2 = activity.createPendingResult(this.zzadi, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onFullWalletLoaded");
                    return;
                }
                try {
                    pendingIntent2.send(n2);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        @Override
        public void zza(int n, boolean bl, Bundle bundle) {
            Activity activity = (Activity)this.zzaYs.get();
            if (activity == null) {
                Log.d((String)"WalletClientImpl", (String)"Ignoring onPreAuthorizationDetermined, Activity has gone");
                return;
            }
            Intent intent = new Intent();
            intent.putExtra("com.google.android.gm.wallet.EXTRA_IS_USER_PREAUTHORIZED", bl);
            PendingIntent pendingIntent = activity.createPendingResult(this.zzadi, intent, 0x40000000);
            if (pendingIntent == null) {
                Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onPreAuthorizationDetermined");
                return;
            }
            try {
                pendingIntent.send(-1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            }
        }

        @Override
        public void zzj(int n, Bundle bundle) {
            zzx.zzb((Object)bundle, (Object)"Bundle should not be null");
            Activity activity = (Activity)this.zzaYs.get();
            if (activity == null) {
                Log.d((String)"WalletClientImpl", (String)"Ignoring onWalletObjectsCreated, Activity has gone");
                return;
            }
            PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
            ConnectionResult connectionResult = new ConnectionResult(n, pendingIntent);
            if (connectionResult.hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(activity, this.zzadi);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                Log.e((String)"WalletClientImpl", (String)("Create Wallet Objects confirmation UI will not be shown connection result: " + connectionResult));
                Intent intent = new Intent();
                intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", 413);
                PendingIntent pendingIntent2 = activity.createPendingResult(this.zzadi, intent, 0x40000000);
                if (pendingIntent2 == null) {
                    Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onWalletObjectsCreated");
                    return;
                }
                try {
                    pendingIntent2.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        @Override
        public void zzb(int n, boolean bl, Bundle bundle) {
            Activity activity = (Activity)this.zzaYs.get();
            if (activity == null) {
                Log.d((String)"WalletClientImpl", (String)"Ignoring onIsNewUserDetermined, Activity has gone");
                return;
            }
            Intent intent = new Intent();
            intent.putExtra("com.google.android.gms.wallet.EXTRA_IS_NEW_USER", bl);
            PendingIntent pendingIntent = activity.createPendingResult(this.zzadi, intent, 0x40000000);
            if (pendingIntent == null) {
                Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onIsNewUserDetermined");
                return;
            }
            try {
                pendingIntent.send(-1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            }
        }
    }

    private static class zza
    extends zzrf.zza {
        private zza() {
        }

        @Override
        public void zza(int n, MaskedWallet maskedWallet, Bundle bundle) {
        }

        @Override
        public void zza(int n, FullWallet fullWallet, Bundle bundle) {
        }

        @Override
        public void zza(int n, boolean bl, Bundle bundle) {
        }

        @Override
        public void zzj(int n, Bundle bundle) {
        }

        @Override
        public void zza(Status status, GetInstrumentsResponse getInstrumentsResponse, Bundle bundle) {
        }

        @Override
        public void zzb(int n, boolean bl, Bundle bundle) {
        }

        @Override
        public void zza(Status status, GetBuyFlowInitializationTokenResponse getBuyFlowInitializationTokenResponse, Bundle bundle) {
        }
    }
}

