/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.util.DisplayMetrics;
import android.util.TypedValue;

public class Dimension {
    public static final int UNIT_PX = 0;
    public static final int UNIT_DIP = 1;
    public static final int UNIT_SP = 2;
    public static final int UNIT_PT = 3;
    public static final int UNIT_IN = 4;
    public static final int UNIT_MM = 5;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;

    public static long zza(int n, float f) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Dimension.zzu(n, Float.floatToIntBits(f));
            }
        }
        throw new IllegalArgumentException("Unrecognized unit: " + n);
    }

    public static long zzhC(int n) {
        if (n < 0) {
            if (n == -1 || n == -2) {
                return Dimension.zzu(129, n);
            }
            throw new IllegalArgumentException("Unexpected dimension value: " + n);
        }
        return Dimension.zza(0, n);
    }

    public static long zza(TypedValue typedValue) {
        switch (typedValue.type) {
            case 16: {
                return Dimension.zzhC(typedValue.data);
            }
            case 5: {
                return Dimension.zzu(128, typedValue.data);
            }
        }
        throw new IllegalArgumentException("Unexpected dimension type: " + typedValue.type);
    }

    public static int zza(long l, DisplayMetrics displayMetrics) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = -1;
        switch (n) {
            case 129: {
                return n2;
            }
            case 128: {
                return TypedValue.complexToDimensionPixelSize((int)n2, (DisplayMetrics)displayMetrics);
            }
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 4;
                break;
            }
            case 5: {
                n3 = 5;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected unit or type: " + n);
            }
        }
        return Math.round(TypedValue.applyDimension((int)n3, (float)Float.intBitsToFloat(n2), (DisplayMetrics)displayMetrics));
    }

    private static long zzu(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private Dimension() {
    }
}

