/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzvw;
import com.google.android.gms.internal.zzwh;
import com.google.android.gms.internal.zzwi;
import com.google.android.gms.internal.zzwk;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzr;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzc<zzwi> zzGR = new Api.zzc();
    private static final Api.zzb<zzwi, WalletOptions> zzGS = new Api.zzb<zzwi, WalletOptions>(){

        public zzwi zza(Context context, Looper looper, zzf zzf2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzx.zzb((boolean)(context instanceof Activity), (Object)"An Activity must be used for Wallet APIs");
            Activity activity = (Activity)context;
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new zzwi(activity, looper, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, zzf2.getAccountName(), walletOptions2.theme);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };
    public static final Api<WalletOptions> API = new Api(zzGS, zzGR, new Scope[0]);
    public static final Payments Payments = new zzwh();
    public static final zzr zzaEm = new zzwl();
    public static final zzvw zzaEn = new zzwk();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int requestCode) {
        Payments.checkForPreAuthorization(googleApiClient, requestCode);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest request, int requestCode) {
        Payments.loadMaskedWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest request, int requestCode) {
        Payments.loadFullWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String googleTransactionId, String merchantTransactionId, int requestCode) {
        Payments.changeMaskedWallet(googleApiClient, googleTransactionId, merchantTransactionId, requestCode);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest request) {
        Payments.notifyTransactionStatus(googleApiClient, request);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zzwi> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzGR, googleApiClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzaEo;
            this.theme = builder.mTheme;
        }

        public static final class Builder {
            private int zzaEo = 0;
            private int mTheme = 0;

            public Builder setEnvironment(int environment) {
                if (environment != 0 && environment != 2 && environment != 1) {
                    String string = String.format(Locale.US, "Invalid environment value %d", environment);
                    throw new IllegalArgumentException(string);
                }
                this.zzaEo = environment;
                return this;
            }

            public Builder setTheme(int theme) {
                if (theme != 0 && theme != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", theme);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = theme;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

