/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.contract;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.contract.ApiTaskResult;

public final class TaskResultContracts {
    private TaskResultContracts() {
    }

    public static final class GetPaymentDataResult
    extends GetApiTaskResult<PaymentData> {
        @Override
        @Nullable
        protected PaymentData taskResultFromIntent(@NonNull Intent intent) {
            return PaymentData.getFromIntent(intent);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NonNull
        public ApiTaskResult<PaymentData> parseResult(int resultCode, @Nullable Intent intent) {
            void var1_1;
            void var2_3;
            switch (resultCode) {
                case 1: {
                    GetPaymentDataResult getPaymentDataResult = AutoResolveHelper.getStatusFromIntent((Intent)var2_3);
                    if (getPaymentDataResult == null) {
                        getPaymentDataResult = Status.RESULT_INTERNAL_ERROR;
                    }
                    ApiTaskResult<PaymentData> apiTaskResult = new ApiTaskResult<PaymentData>((Status)getPaymentDataResult);
                    return apiTaskResult;
                }
            }
            return super.parseResult((int)var1_1, (Intent)var2_3);
        }
    }

    public static abstract class GetApiTaskResult<T>
    extends ResolveApiTaskResult<T, ApiTaskResult<T>> {
        /*
         * WARNING - void declaration
         */
        @Override
        @NonNull
        protected ApiTaskResult<T> outputFromTask(@NonNull Task<T> task) {
            Object object;
            void var1_1;
            if (task.isSuccessful()) {
                return new ApiTaskResult<Object>(var1_1.getResult(), Status.RESULT_SUCCESS);
            }
            if (var1_1.isCanceled()) {
                object = "The task has been canceled.";
                return new ApiTaskResult(new Status(16, (String)object));
            }
            object = object.zza;
            if (object != null) {
                return new ApiTaskResult((Status)object);
            }
            return new ApiTaskResult(Status.RESULT_INTERNAL_ERROR);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public ApiTaskResult<T> parseResult(int resultCode, @Nullable Intent intent) {
            switch (resultCode) {
                case 0: {
                    return new ApiTaskResult<Object>(null, Status.RESULT_CANCELED);
                }
                case -1: {
                    void var0_2;
                    void var2_5;
                    if (var2_5 != null) {
                        T t = this.taskResultFromIntent((Intent)var2_5);
                    } else {
                        Object var0_3 = null;
                    }
                    if (var0_2 != null) {
                        return new ApiTaskResult<void>(var0_2, Status.RESULT_SUCCESS);
                    }
                    return new ApiTaskResult<Object>(null, Status.RESULT_INTERNAL_ERROR);
                }
            }
            return new ApiTaskResult<Object>(null, Status.RESULT_INTERNAL_ERROR);
        }

        @Nullable
        protected abstract T taskResultFromIntent(@NonNull Intent var1);
    }

    public static final class GetPaymentData
    extends UnpackApiTaskResult<PaymentData> {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public PaymentData parseResult(int n, @Nullable Intent intent) {
            if (intent != null) {
                void var2_2;
                return PaymentData.getFromIntent((Intent)var2_2);
            }
            return null;
        }
    }

    public static abstract class UnpackApiTaskResult<T>
    extends ResolveApiTaskResult<T, T> {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected T outputFromTask(@NonNull Task<T> task) {
            if (task.isSuccessful()) {
                void var1_1;
                return (T)var1_1.getResult();
            }
            return null;
        }
    }

    public static abstract class ResolveApiTaskResult<I, O>
    extends ActivityResultContract<Task<I>, O> {
        Status zza;
        private PendingIntent zzb;

        @NonNull
        public Intent createIntent(@NonNull Context context, @NonNull Task<I> task) {
            ResolveApiTaskResult resolveApiTaskResult = new IntentSenderRequest.Builder(resolveApiTaskResult.zzb).build();
            return new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST").putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", (Parcelable)resolveApiTaskResult);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public ActivityResultContract.SynchronousResult<O> getSynchronousResult(@NonNull Context object, @NonNull Task<I> input) {
            void var2_2;
            if (!input.isComplete()) {
                throw new IllegalArgumentException("The task has to be executed before using this API to resolve its result.");
            }
            object = var2_2.getException();
            if (object instanceof ApiException) {
                this.zza = ((ApiException)object).getStatus();
                if (object instanceof ResolvableApiException) {
                    this.zzb = ((ResolvableApiException)object).getResolution();
                }
            }
            if (this.zzb == null) {
                return new ActivityResultContract.SynchronousResult(this.outputFromTask((Task<I>)var2_2));
            }
            return null;
        }

        protected abstract O outputFromTask(@NonNull Task<I> var1);
    }
}

