/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzv;
import com.google.android.gms.wallet.zzw;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzw();
    @SafeParcelable.Field(id=1)
    boolean zzdj;
    @SafeParcelable.Field(id=2)
    boolean zzdk;
    @SafeParcelable.Field(id=3)
    CardRequirements zzdl;
    @SafeParcelable.Field(id=4)
    boolean zzdm;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zzdn;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzca;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzdo;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzdp;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzdq;
    @SafeParcelable.Field(id=10)
    String zzcc;
    @SafeParcelable.Field(id=11)
    private Bundle zzdh;

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string, @SafeParcelable.Param(id=11) Bundle bundle) {
        this.zzdj = bl;
        this.zzdk = bl2;
        this.zzdl = cardRequirements;
        this.zzdm = bl3;
        this.zzdn = shippingAddressRequirements;
        this.zzca = arrayList;
        this.zzdo = paymentMethodTokenizationParameters;
        this.zzdp = transactionInfo;
        this.zzdq = bl4;
        this.zzcc = string;
        this.zzdh = bundle;
    }

    private PaymentDataRequest() {
        this.zzdq = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzdj);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzdk);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzdl, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzdm);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzdn, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, paymentDataRequest.zzca, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzdo, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzdp, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzdq);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)paymentDataRequest.zzcc, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)11, (Bundle)paymentDataRequest.zzdh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Deprecated
    public final boolean isEmailRequired() {
        return this.zzdj;
    }

    @Deprecated
    public final boolean isPhoneNumberRequired() {
        return this.zzdk;
    }

    @Deprecated
    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzdl;
    }

    @Deprecated
    public final boolean isShippingAddressRequired() {
        return this.zzdm;
    }

    @Deprecated
    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzdn;
    }

    @Deprecated
    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzca;
    }

    @Deprecated
    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzdo;
    }

    @Deprecated
    public final TransactionInfo getTransactionInfo() {
        return this.zzdp;
    }

    @Deprecated
    public final boolean isUiRequired() {
        return this.zzdq;
    }

    @Deprecated
    public static Builder newBuilder() {
        return new PaymentDataRequest().new Builder(null);
    }

    public static PaymentDataRequest fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataRequestJson cannot be null!");
        Builder builder = PaymentDataRequest.newBuilder();
        PaymentDataRequest.newBuilder().PaymentDataRequest.this.zzcc = string2;
        return builder.build();
    }

    public final String toJson() {
        return this.zzcc;
    }

    public final PaymentDataRequest withSavedState(@Nullable Bundle bundle) {
        this.zzdh = bundle;
        return this;
    }

    @Nullable
    public final Bundle getSavedState() {
        return this.zzdh;
    }

    @Deprecated
    public final class Builder {
        private Builder() {
        }

        public final Builder setEmailRequired(boolean bl) {
            PaymentDataRequest.this.zzdj = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            PaymentDataRequest.this.zzdk = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            PaymentDataRequest.this.zzdl = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            PaymentDataRequest.this.zzdm = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            PaymentDataRequest.this.zzdn = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (PaymentDataRequest.this.zzca == null) {
                PaymentDataRequest.this.zzca = new ArrayList();
            }
            PaymentDataRequest.this.zzca.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (PaymentDataRequest.this.zzca == null) {
                PaymentDataRequest.this.zzca = new ArrayList();
            }
            PaymentDataRequest.this.zzca.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            PaymentDataRequest.this.zzdo = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            PaymentDataRequest.this.zzdp = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            PaymentDataRequest.this.zzdq = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            if (PaymentDataRequest.this.zzcc == null) {
                Preconditions.checkNotNull(PaymentDataRequest.this.zzca, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdl), (Object)"Card requirements must be set!");
                if (PaymentDataRequest.this.zzdo != null) {
                    Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdp), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzv zzv2) {
            this();
        }
    }
}

