/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.CardInfo;
import com.google.android.gms.wallet.PaymentMethodToken;
import com.google.android.gms.wallet.zzt;
import com.google.android.gms.wallet.zzu;

@SafeParcelable.Class(creator="PaymentDataCreator")
public final class PaymentData
extends AbstractSafeParcelable
implements AutoResolvableResult {
    public static final Parcelable.Creator<PaymentData> CREATOR = new zzu();
    @SafeParcelable.Field(id=1)
    private String zzbf;
    @SafeParcelable.Field(id=2)
    private CardInfo zzde;
    @SafeParcelable.Field(id=3)
    private UserAddress zzdf;
    @SafeParcelable.Field(id=4)
    private PaymentMethodToken zzbm;
    @SafeParcelable.Field(id=5)
    private String zzbc;
    @SafeParcelable.Field(id=6)
    private Bundle zzdg;
    @SafeParcelable.Field(id=7)
    private String zzcc;
    @SafeParcelable.Field(id=8)
    private Bundle zzdh;

    @SafeParcelable.Constructor
    PaymentData(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) CardInfo cardInfo, @SafeParcelable.Param(id=3) UserAddress userAddress, @SafeParcelable.Param(id=4) PaymentMethodToken paymentMethodToken, @SafeParcelable.Param(id=5) String string2, @SafeParcelable.Param(id=6) Bundle bundle, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Bundle bundle2) {
        this.zzbf = string;
        this.zzde = cardInfo;
        this.zzdf = userAddress;
        this.zzbm = paymentMethodToken;
        this.zzbc = string2;
        this.zzdg = bundle;
        this.zzcc = string3;
        this.zzdh = bundle2;
    }

    private PaymentData() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentData paymentData = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)paymentData.zzbf, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)paymentData.zzde, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentData.zzdf, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)paymentData.zzbm, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)paymentData.zzbc, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)6, (Bundle)paymentData.zzdg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)paymentData.zzcc, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)8, (Bundle)paymentData.zzdh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Deprecated
    @Nullable
    public final String getEmail() {
        return this.zzbf;
    }

    @Deprecated
    public final CardInfo getCardInfo() {
        return this.zzde;
    }

    @Deprecated
    @Nullable
    public final UserAddress getShippingAddress() {
        return this.zzdf;
    }

    @Deprecated
    @Nullable
    public final PaymentMethodToken getPaymentMethodToken() {
        return this.zzbm;
    }

    @Deprecated
    public final String getGoogleTransactionId() {
        return this.zzbc;
    }

    @Deprecated
    @Nullable
    public final Bundle getExtraData() {
        return this.zzdg;
    }

    public static PaymentData fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataJson cannot be null!");
        zza zza2 = new PaymentData().new zza(null);
        new PaymentData().new zza(null).PaymentData.this.zzcc = string2;
        return zza2.PaymentData.this;
    }

    public final String toJson() {
        return this.zzcc;
    }

    public final PaymentData withLastSavedState(@Nullable Bundle bundle) {
        this.zzdh = bundle;
        return this;
    }

    @Nullable
    public final Bundle getLastSavedState() {
        return this.zzdh;
    }

    @Nullable
    public static PaymentData getFromIntent(@NonNull Intent intent) {
        return (PaymentData)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.gms.wallet.PaymentData", CREATOR);
    }

    @Override
    public final void putIntoIntent(@NonNull Intent intent) {
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.gms.wallet.PaymentData");
    }

    public final class zza {
        private zza() {
        }

        /* synthetic */ zza(zzt zzt2) {
            this();
        }
    }
}

