/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzr;
import com.google.android.gms.wallet.zzs;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="OfferWalletObjectCreator")
public final class OfferWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<OfferWalletObject> CREATOR = new zzs();
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int versionCode;
    @SafeParcelable.Field(id=2)
    String zzce;
    @SafeParcelable.Field(id=3)
    String zzdc;
    @SafeParcelable.Field(id=4)
    CommonWalletObject zzbn;

    public static Builder newBuilder() {
        return new OfferWalletObject().new Builder(null);
    }

    public final int getVersionCode() {
        return this.versionCode;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        OfferWalletObject offerWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)offerWalletObject.getVersionCode());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)offerWalletObject.zzce, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)offerWalletObject.zzdc, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)offerWalletObject.zzbn, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    OfferWalletObject(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) CommonWalletObject commonWalletObject) {
        this.versionCode = n;
        this.zzdc = string2;
        if (n < 3) {
            this.zzbn = CommonWalletObject.zzg().zza(string).zzh();
            return;
        }
        this.zzbn = commonWalletObject;
    }

    OfferWalletObject() {
        this.versionCode = 3;
    }

    public final String getId() {
        return this.zzbn.getId();
    }

    public final String getRedemptionCode() {
        return this.zzdc;
    }

    public final String getClassId() {
        return this.zzbn.getClassId();
    }

    public final String getTitle() {
        return this.zzbn.getName();
    }

    public final String getIssuerName() {
        return this.zzbn.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbn.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbn.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbn.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbn.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbn.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbn.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbn.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbn.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbn.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbn.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbn.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbn.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbn.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbn.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbn.getLinksModuleDataUris();
    }

    public final class Builder {
        private CommonWalletObject.zza zzbu = CommonWalletObject.zzg();

        private Builder() {
        }

        public final Builder setId(String string) {
            this.zzbu.zza(string);
            OfferWalletObject.this.zzce = string;
            return this;
        }

        public final Builder setRedemptionCode(String string) {
            OfferWalletObject.this.zzdc = string;
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbu.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbu.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbu.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbu.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbu.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbu.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbu.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbu.zzd(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbu.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbu.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbu.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbu.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbu.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbu.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbu.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbu.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbu.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbu.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbu.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbu.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbu.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbu.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbu.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbu.zzb(uriData);
            return this;
        }

        public final OfferWalletObject build() {
            OfferWalletObject.this.zzbn = this.zzbu.zzh();
            return OfferWalletObject.this;
        }

        /* synthetic */ Builder(zzr zzr2) {
            this();
        }
    }
}

