/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzj;
import com.google.android.gms.wallet.zzk;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzk();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zzbn = CommonWalletObject.zzg().zzh();
    @SafeParcelable.Field(id=3)
    String zzbo;
    @SafeParcelable.Field(id=4)
    String pin;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzbp;
    @SafeParcelable.Field(id=6)
    long zzbq;
    @SafeParcelable.Field(id=7)
    String zzbr;
    @SafeParcelable.Field(id=8)
    long zzbs;
    @SafeParcelable.Field(id=9)
    String zzbt;

    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GiftCardWalletObject giftCardWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)giftCardWalletObject.zzbn, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)giftCardWalletObject.zzbo, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)giftCardWalletObject.pin, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)giftCardWalletObject.zzbp, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)giftCardWalletObject.zzbq);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)giftCardWalletObject.zzbr, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)giftCardWalletObject.zzbs);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)giftCardWalletObject.zzbt, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    GiftCardWalletObject() {
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        this.zzbn = commonWalletObject;
        this.zzbo = string;
        this.pin = string2;
        this.zzbq = l;
        this.zzbr = string4;
        this.zzbs = l2;
        this.zzbt = string5;
        this.zzbp = string3;
    }

    public final String getId() {
        return this.zzbn.getId();
    }

    public final String getClassId() {
        return this.zzbn.getClassId();
    }

    public final String getTitle() {
        return this.zzbn.getName();
    }

    public final String getIssuerName() {
        return this.zzbn.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbn.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbn.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbn.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbn.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbn.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbn.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbn.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbn.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbn.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbn.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbn.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbn.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbn.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbn.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbn.getLinksModuleDataUris();
    }

    public final String getCardNumber() {
        return this.zzbo;
    }

    public final String getPin() {
        return this.pin;
    }

    public final long getBalanceMicros() {
        return this.zzbq;
    }

    public final String getBalanceCurrencyCode() {
        return this.zzbr;
    }

    public final long getBalanceUpdateTime() {
        return this.zzbs;
    }

    public final String getEventNumber() {
        return this.zzbt;
    }

    @Deprecated
    public final String getCardIdentifier() {
        return this.zzbp;
    }

    public final class Builder {
        private CommonWalletObject.zza zzbu = CommonWalletObject.zzg();

        private Builder() {
        }

        public final Builder setCardNumber(String string) {
            GiftCardWalletObject.this.zzbo = string;
            return this;
        }

        public final Builder setPin(String string) {
            GiftCardWalletObject.this.pin = string;
            return this;
        }

        public final Builder setBalanceMicros(long l) {
            GiftCardWalletObject.this.zzbq = l;
            return this;
        }

        public final Builder setBalanceCurrencyCode(String string) {
            GiftCardWalletObject.this.zzbr = string;
            return this;
        }

        public final Builder setBalanceUpdateTime(long l) {
            GiftCardWalletObject.this.zzbs = l;
            return this;
        }

        public final Builder setEventNumber(String string) {
            GiftCardWalletObject.this.zzbt = string;
            return this;
        }

        @Deprecated
        public final Builder setCardIdentifier(String string) {
            GiftCardWalletObject.this.zzbp = string;
            return this;
        }

        public final Builder setId(String string) {
            this.zzbu.zza(string);
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbu.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbu.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbu.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbu.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbu.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbu.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbu.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbu.zzd(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbu.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbu.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbu.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbu.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbu.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbu.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbu.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbu.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbu.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbu.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbu.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbu.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbu.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbu.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbu.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbu.zzb(uriData);
            return this;
        }

        public final GiftCardWalletObject build() {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbo) ? 1 : 0) != 0, (Object)"Card number is required.");
            GiftCardWalletObject.this.zzbn = this.zzbu.zzh();
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbn.getName()) ? 1 : 0) != 0, (Object)"Card name is required.");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbn.getIssuerName()) ? 1 : 0) != 0, (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzj zzj2) {
            this();
        }
    }
}

