/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzd;
import com.google.android.gms.wallet.zze;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="CardRequirementsCreator")
public final class CardRequirements
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CardRequirements> CREATOR = new zze();
    @SafeParcelable.Field(id=1)
    ArrayList<Integer> zzao;
    @SafeParcelable.Field(id=2, defaultValue="true")
    boolean zzap;
    @SafeParcelable.Field(id=3)
    boolean zzaq;
    @SafeParcelable.Field(id=4)
    int zzar;

    @SafeParcelable.Constructor
    CardRequirements(@SafeParcelable.Param(id=1) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) int n) {
        this.zzao = arrayList;
        this.zzap = bl;
        this.zzaq = bl2;
        this.zzar = n;
    }

    private CardRequirements() {
        this.zzap = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CardRequirements cardRequirements = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)1, cardRequirements.zzao, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)cardRequirements.zzap);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)cardRequirements.zzaq);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)cardRequirements.zzar);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzao;
    }

    public final boolean allowPrepaidCards() {
        return this.zzap;
    }

    public final boolean isBillingAddressRequired() {
        return this.zzaq;
    }

    public final int getBillingAddressFormat() {
        return this.zzar;
    }

    public static Builder newBuilder() {
        return new CardRequirements().new Builder(null);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder addAllowedCardNetwork(int n) {
            if (CardRequirements.this.zzao == null) {
                CardRequirements.this.zzao = new ArrayList();
            }
            CardRequirements.this.zzao.add(n);
            return this;
        }

        public final Builder addAllowedCardNetworks(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedCardNetworks can't be null or empty! You must provide a valid value from WalletConstants.CardNetwork.");
            if (CardRequirements.this.zzao == null) {
                CardRequirements.this.zzao = new ArrayList();
            }
            CardRequirements.this.zzao.addAll(collection);
            return this;
        }

        public final Builder setAllowPrepaidCards(boolean bl) {
            CardRequirements.this.zzap = bl;
            return this;
        }

        public final Builder setBillingAddressRequired(boolean bl) {
            CardRequirements.this.zzaq = bl;
            return this;
        }

        public final Builder setBillingAddressFormat(int n) {
            CardRequirements.this.zzar = n;
            return this;
        }

        public final CardRequirements build() {
            Preconditions.checkNotNull(CardRequirements.this.zzao, (Object)"Allowed card networks must be non-empty! You can set it through addAllowedCardNetwork() or addAllowedCardNetworks() in the CardRequirements Builder.");
            return CardRequirements.this;
        }

        /* synthetic */ Builder(zzd zzd2) {
            this();
        }
    }
}

