/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzab;
import com.google.android.gms.internal.wallet.zzac;
import com.google.android.gms.internal.wallet.zzad;
import com.google.android.gms.internal.wallet.zzae;
import com.google.android.gms.internal.wallet.zzt;
import com.google.android.gms.internal.wallet.zzv;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.internal.wallet.zzz;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.zzg;

public final class zzaa
extends GmsClient<zzt> {
    private final Context zzfn;
    private final int environment;
    private final String zzci;
    private final int theme;
    private final boolean zzem;

    public zzaa(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzfn = context;
        this.environment = n;
        this.zzci = clientSettings.getAccountName();
        this.theme = n2;
        this.zzem = bl;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzz zzz2 = new zzz((Activity)this.zzfn, n);
        Bundle bundle = this.zzf();
        try {
            ((zzt)this.getService()).zza(createWalletObjectsRequest, bundle, (zzv)zzz2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzac)zzz2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzf();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzae zzae2 = new zzae(taskCompletionSource);
        try {
            ((zzt)this.getService()).zza(createWalletObjectsRequest, bundle, (zzv)zzae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzac)zzae2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzab zzab2 = new zzab(taskCompletionSource);
        try {
            ((zzt)this.getService()).zza(isReadyToPayRequest, this.zzf(), (zzv)zzab2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzac)zzab2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzf();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzad zzad2 = new zzad(taskCompletionSource);
        try {
            ((zzt)this.getService()).zza(paymentDataRequest, bundle, (zzv)zzad2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzac)zzad2).zza(Status.RESULT_INTERNAL_ERROR, (PaymentData)null, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzf() {
        boolean bl = this.zzem;
        int n = this.theme;
        String string = this.zzci;
        String string2 = this.zzfn.getPackageName();
        int n2 = this.environment;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    public final int getMinApkVersion() {
        return 12600000;
    }

    public final Feature[] getApiFeatures() {
        return zzg.zzbb;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzt) {
            return (zzt)iInterface;
        }
        return new zzw(iBinder2);
    }
}

