/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.zzdju;
import com.google.android.gms.internal.zzdjy;
import com.google.android.gms.internal.zzdkt;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzlbp;
    private boolean mCreated = false;
    private final zzr zzlbq = zzr.zza((Fragment)this);
    private final zzc zzlbr = new zzc(this, null);
    private zza zzlbs = new zza(this);
    private final Fragment zzgtv = this;
    private WalletFragmentOptions zzlbt;
    private WalletFragmentInitParams zzlbu;
    private MaskedWalletRequest zzlbv;
    private MaskedWallet zzlbw;
    private Boolean zzlbx;

    public SupportWalletFragment() {
    }

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzgtv.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzlbp != null) {
            this.zzlbp.initialize(walletFragmentInitParams);
            this.zzlbu = null;
            return;
        }
        if (this.zzlbu == null) {
            this.zzlbu = walletFragmentInitParams;
            if (this.zzlbv != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzlbw != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzlbp != null) {
            this.zzlbp.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzlbv = null;
            return;
        }
        this.zzlbv = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzlbp != null) {
            this.zzlbp.updateMaskedWallet(maskedWallet);
            this.zzlbw = null;
            return;
        }
        this.zzlbw = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzlbp != null) {
            this.zzlbp.setEnabled(bl);
            this.zzlbx = null;
            return;
        }
        this.zzlbx = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzlbs.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzlbp != null) {
            return this.zzlbp.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzlbt == null) {
            this.zzlbt = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzlbt);
        this.zzlbr.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzlbu != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzlbu = walletFragmentInitParams;
            }
            if (this.zzlbv == null) {
                this.zzlbv = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzlbw == null) {
                this.zzlbw = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzlbt = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzlbx = bundle.getBoolean("enabled");
            }
        } else if (this.zzgtv.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgtv.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzel((Context)this.zzgtv.getActivity());
            this.zzlbt = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzlbr.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzlbr.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzlbr.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzlbr.onResume();
        FragmentManager fragmentManager = this.zzgtv.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgtv.getActivity()), (Activity)this.zzgtv.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzlbr.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzlbr.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzlbr.onSaveInstanceState(bundle);
        if (this.zzlbu != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzlbu);
            this.zzlbu = null;
        }
        if (this.zzlbv != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzlbv);
            this.zzlbv = null;
        }
        if (this.zzlbw != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzlbw);
            this.zzlbw = null;
        }
        if (this.zzlbt != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzlbt);
            this.zzlbt = null;
        }
        if (this.zzlbx != null) {
            bundle.putBoolean("enabled", this.zzlbx.booleanValue());
            this.zzlbx = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzlbp != null) {
            this.zzlbp.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzlbt = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzlbu = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzlbv = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzlbw = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzlbx = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzdjy {
        private OnStateChangedListener zzlby;
        private final SupportWalletFragment zzlbz;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzlbz = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzlby != null) {
                this.zzlby.onStateChanged(this.zzlbz, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzlby = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzdju zzlca;

        private zzb(zzdju zzdju2) {
            this.zzlca = zzdju2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzlca.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzlca.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzlca.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzlca.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzlca.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzlca.zza(zzn.zzy((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzlca.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzx((IObjectWrapper)this.zzlca.onCreateView(zzn.zzy((Object)layoutInflater), zzn.zzy((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzlca.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzlca.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzlca.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzlca.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzlca.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzlca.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzdju zzdju2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(zzdju2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzlcb;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzlcb = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzlcb.zzgtv.getActivity();
            if (this.zzlcb.zzlbp == null && this.zzlcb.mCreated && fragmentActivity != null) {
                try {
                    zzdju zzdju2 = zzdkt.zza((Activity)fragmentActivity, (zzk)this.zzlcb.zzlbq, this.zzlcb.zzlbt, this.zzlcb.zzlbs);
                    this.zzlcb.zzlbp = new zzb(zzdju2, null);
                    SupportWalletFragment.zza(this.zzlcb, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzlcb.zzlbp);
                if (this.zzlcb.zzlbu != null) {
                    this.zzlcb.zzlbp.initialize(this.zzlcb.zzlbu);
                    SupportWalletFragment.zza(this.zzlcb, null);
                }
                if (this.zzlcb.zzlbv != null) {
                    this.zzlcb.zzlbp.updateMaskedWalletRequest(this.zzlcb.zzlbv);
                    SupportWalletFragment.zza(this.zzlcb, null);
                }
                if (this.zzlcb.zzlbw != null) {
                    this.zzlcb.zzlbp.updateMaskedWallet(this.zzlcb.zzlbw);
                    SupportWalletFragment.zza(this.zzlcb, null);
                }
                if (this.zzlcb.zzlbx != null) {
                    this.zzlcb.zzlbp.setEnabled(this.zzlcb.zzlbx);
                    SupportWalletFragment.zza(this.zzlcb, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzlcb.zzgtv.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzlcb.zzlbt != null && (walletFragmentStyle = this.zzlcb.zzlbt.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzlcb.zzgtv.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzlcb.zzgtv.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

