/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbej {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zzlad;
    boolean zzlae;
    CardRequirements zzlaf;
    boolean zzlag;
    ShippingAddressRequirements zzlah;
    ArrayList<Integer> zzkyh;
    PaymentMethodTokenizationParameters zzlai;
    TransactionInfo zzlaj;
    boolean zzlak;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zzlad = bl;
        this.zzlae = bl2;
        this.zzlaf = cardRequirements;
        this.zzlag = bl3;
        this.zzlah = shippingAddressRequirements;
        this.zzkyh = arrayList;
        this.zzlai = paymentMethodTokenizationParameters;
        this.zzlaj = transactionInfo;
        this.zzlak = bl4;
    }

    private PaymentDataRequest() {
        this.zzlak = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzlad);
        zzbem.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzlae);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzlaf, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzlag);
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzlah, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzkyh, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzlai, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzlaj, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzlak);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzlad;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzlae;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzlaf;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzlag;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzlah;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzkyh;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzlai;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzlaj;
    }

    public final boolean isUiRequired() {
        return this.zzlak;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zzlal;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zzlal = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zzlal.zzlad = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zzlal.zzlae = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zzlal.zzlaf = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zzlal.zzlag = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zzlal.zzlah = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zzlal.zzkyh == null) {
                this.zzlal.zzkyh = new ArrayList();
            }
            this.zzlal.zzkyh.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zzlal.zzkyh == null) {
                this.zzlal.zzkyh = new ArrayList();
            }
            this.zzlal.zzkyh.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zzlal.zzlai = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zzlal.zzlaj = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zzlal.zzlak = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbq.checkNotNull(this.zzlal.zzkyh, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbq.checkNotNull((Object)((Object)this.zzlal.zzlaf), (Object)"Card requirements must be set!");
            if (this.zzlal.zzlai != null) {
                zzbq.checkNotNull((Object)((Object)this.zzlal.zzlaj), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
            }
            return this.zzlal;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

