/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzdec;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.MaskedWallet;
import java.lang.ref.WeakReference;

final class zzdeb
extends zzdec {
    private final WeakReference<Activity> zzdwz;
    private final int zzfhm;

    public zzdeb(Activity activity, int n) {
        this.zzdwz = new WeakReference<Activity>(activity);
        this.zzfhm = n;
    }

    @Override
    public final void zza(int n, MaskedWallet maskedWallet, Bundle bundle) {
        int n2;
        ConnectionResult connectionResult;
        Activity activity = (Activity)this.zzdwz.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onMaskedWalletLoaded, Activity has gone");
            return;
        }
        PendingIntent pendingIntent = null;
        if (bundle != null) {
            pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
        }
        if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
            try {
                connectionResult.startResolutionForResult(activity, this.zzfhm);
                return;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                return;
            }
        }
        Intent intent = new Intent();
        if (connectionResult.isSuccess()) {
            n2 = -1;
            intent.putExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET", (Parcelable)maskedWallet);
        } else {
            n2 = n == 408 ? 0 : 1;
            intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
        }
        PendingIntent pendingIntent2 = activity.createPendingResult(this.zzfhm, intent, 0x40000000);
        if (pendingIntent2 == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onMaskedWalletLoaded");
            return;
        }
        try {
            pendingIntent2.send(n2);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }

    @Override
    public final void zza(int n, FullWallet fullWallet, Bundle bundle) {
        int n2;
        ConnectionResult connectionResult;
        Activity activity = (Activity)this.zzdwz.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onFullWalletLoaded, Activity has gone");
            return;
        }
        PendingIntent pendingIntent = null;
        if (bundle != null) {
            pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
        }
        if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
            try {
                connectionResult.startResolutionForResult(activity, this.zzfhm);
                return;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                return;
            }
        }
        Intent intent = new Intent();
        if (connectionResult.isSuccess()) {
            n2 = -1;
            intent.putExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET", (Parcelable)fullWallet);
        } else {
            n2 = n == 408 ? 0 : 1;
            intent.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
        }
        PendingIntent pendingIntent2 = activity.createPendingResult(this.zzfhm, intent, 0x40000000);
        if (pendingIntent2 == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onFullWalletLoaded");
            return;
        }
        try {
            pendingIntent2.send(n2);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }

    @Override
    public final void zza(int n, boolean bl, Bundle bundle) {
        Activity activity = (Activity)this.zzdwz.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onPreAuthorizationDetermined, Activity has gone");
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("com.google.android.gm.wallet.EXTRA_IS_USER_PREAUTHORIZED", bl);
        PendingIntent pendingIntent = activity.createPendingResult(this.zzfhm, intent, 0x40000000);
        if (pendingIntent == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onPreAuthorizationDetermined");
            return;
        }
        try {
            pendingIntent.send(-1);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }

    @Override
    public final void zzg(int n, Bundle bundle) {
        zzbp.zzb((Object)bundle, (Object)"Bundle should not be null");
        Activity activity = (Activity)this.zzdwz.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onWalletObjectsCreated, Activity has gone");
            return;
        }
        PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT");
        ConnectionResult connectionResult = new ConnectionResult(n, pendingIntent);
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult(activity, this.zzfhm);
                return;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                return;
            }
        }
        String string = String.valueOf(connectionResult);
        Log.e((String)"WalletClientImpl", (String)new StringBuilder(75 + String.valueOf(string).length()).append("Create Wallet Objects confirmation UI will not be shown connection result: ").append(string).toString());
        string = new Intent();
        string.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", 413);
        PendingIntent pendingIntent2 = activity.createPendingResult(this.zzfhm, (Intent)string, 0x40000000);
        if (pendingIntent2 == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onWalletObjectsCreated");
            return;
        }
        try {
            pendingIntent2.send(1);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }
}

