/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzg;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbkz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbRN;
    private boolean mCreated = false;
    private final zzg zzbRO = zzg.zza((Fragment)this);
    private final zzc zzbRP = new zzc();
    private zza zzbRQ = new zza(this);
    private final Fragment zzaRN = this;
    private WalletFragmentOptions zzbRR;
    private WalletFragmentInitParams zzbRS;
    private MaskedWalletRequest zzbRT;
    private MaskedWallet zzbRU;
    private Boolean zzbRV;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaRN.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbRN != null) {
            this.zzbRN.initialize(walletFragmentInitParams);
            this.zzbRS = null;
        } else if (this.zzbRS == null) {
            this.zzbRS = walletFragmentInitParams;
            if (this.zzbRT != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbRU != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbRN != null) {
            this.zzbRN.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbRT = null;
        } else {
            this.zzbRT = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbRN != null) {
            this.zzbRN.updateMaskedWallet(maskedWallet);
            this.zzbRU = null;
        } else {
            this.zzbRU = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbRN != null) {
            this.zzbRN.setEnabled(bl);
            this.zzbRV = null;
        } else {
            this.zzbRV = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbRQ.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbRN != null ? this.zzbRN.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbRR == null) {
            this.zzbRR = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbRR);
        this.zzbRP.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbRS != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbRS = walletFragmentInitParams;
            }
            if (this.zzbRT == null) {
                this.zzbRT = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbRU == null) {
                this.zzbRU = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbRR = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbRV = bundle.getBoolean("enabled");
            }
        } else if (this.zzaRN.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaRN.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzci((Context)this.zzaRN.getActivity());
            this.zzbRR = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbRP.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbRP.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbRP.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbRP.onResume();
        FragmentManager fragmentManager = this.zzaRN.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaRN.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaRN.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbRP.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbRP.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbRP.onSaveInstanceState(bundle);
        if (this.zzbRS != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbRS);
            this.zzbRS = null;
        }
        if (this.zzbRT != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbRT);
            this.zzbRT = null;
        }
        if (this.zzbRU != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbRU);
            this.zzbRU = null;
        }
        if (this.zzbRR != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbRR);
            this.zzbRR = null;
        }
        if (this.zzbRV != null) {
            bundle.putBoolean("enabled", this.zzbRV.booleanValue());
            this.zzbRV = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbRN != null) {
            this.zzbRN.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbkt.zza {
        private OnStateChangedListener zzbRW;
        private final SupportWalletFragment zzbRX;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbRX = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbRW != null) {
                this.zzbRW.onStateChanged(this.zzbRX, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbRW = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbks zzbRY;

        private zzb(zzbks zzbks2) {
            this.zzbRY = zzbks2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbRY.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbRY.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbRY.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbRY.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbRY.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbRY.zza(zzd.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbRY.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                IObjectWrapper iObjectWrapper = this.zzbRY.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle);
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbRY.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbRY.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbRY.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbRY.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbRY.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbRY.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zze<zzb> zze2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaRN.getActivity();
            if (SupportWalletFragment.this.zzbRN == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzbks zzbks2 = zzbkz.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzbRO, SupportWalletFragment.this.zzbRR, SupportWalletFragment.this.zzbRQ);
                    SupportWalletFragment.this.zzbRN = new zzb(zzbks2);
                    SupportWalletFragment.this.zzbRR = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zze2.zza((LifecycleDelegate)SupportWalletFragment.this.zzbRN);
                if (SupportWalletFragment.this.zzbRS != null) {
                    SupportWalletFragment.this.zzbRN.initialize(SupportWalletFragment.this.zzbRS);
                    SupportWalletFragment.this.zzbRS = null;
                }
                if (SupportWalletFragment.this.zzbRT != null) {
                    SupportWalletFragment.this.zzbRN.updateMaskedWalletRequest(SupportWalletFragment.this.zzbRT);
                    SupportWalletFragment.this.zzbRT = null;
                }
                if (SupportWalletFragment.this.zzbRU != null) {
                    SupportWalletFragment.this.zzbRN.updateMaskedWallet(SupportWalletFragment.this.zzbRU);
                    SupportWalletFragment.this.zzbRU = null;
                }
                if (SupportWalletFragment.this.zzbRV != null) {
                    SupportWalletFragment.this.zzbRN.setEnabled(SupportWalletFragment.this.zzbRV);
                    SupportWalletFragment.this.zzbRV = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzaRN.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzbRR != null && (walletFragmentStyle = SupportWalletFragment.this.zzbRR.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzaRN.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaRN.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

